/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.extensions.AbstractFormFieldWizard;
import org.eclipse.scout.sdk.ui.extensions.IFormFieldExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.FormFieldExtension;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.osgi.framework.Bundle;

public class FormFieldExtensionPoint {
    private static FormFieldExtensionPoint instance = new FormFieldExtensionPoint();
    private List<IFormFieldExtension> m_extensions;

    private FormFieldExtensionPoint() {
        this.init();
    }

    public static IFormFieldExtension[] getAllFormFieldExtensions() {
        return instance.getAllFormFieldExtensionsImpl();
    }

    private IFormFieldExtension[] getAllFormFieldExtensionsImpl() {
        return this.m_extensions.toArray(new IFormFieldExtension[this.m_extensions.size()]);
    }

    public static AbstractWorkspaceWizard createNewWizard(IType modelType) {
        return instance.createNewWizardImpl(modelType);
    }

    private AbstractWorkspaceWizard createNewWizardImpl(IType modelType) {
        try {
            org.eclipse.jdt.core.ITypeHierarchy superTypeHierarchy = modelType.newSupertypeHierarchy(null);
            IFormFieldExtension[] iFormFieldExtensionArray = this.getSortedExtensions(modelType, superTypeHierarchy, -1);
            int n = iFormFieldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormFieldExtension ext = iFormFieldExtensionArray[n2];
                if (ext.getNewWizardClazz() != null) {
                    return ext.createNewWizard();
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logWarning("could not find form field extension for model type '" + modelType.getFullyQualifiedName() + "'.", e);
        }
        return null;
    }

    public static IFormFieldExtension findExtension(IType modelType, int maxDistance) {
        return instance.findExtensionImpl(modelType, maxDistance);
    }

    private IFormFieldExtension findExtensionImpl(IType modelType, int maxDistance) {
        try {
            org.eclipse.jdt.core.ITypeHierarchy superTypeHierarchy = modelType.newSupertypeHierarchy(null);
            IFormFieldExtension[] sortedExtensions = this.getSortedExtensions(modelType, superTypeHierarchy, maxDistance);
            if (sortedExtensions.length > 0) {
                return sortedExtensions[0];
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logWarning("could not find form field extension for model type '" + modelType.getFullyQualifiedName() + "'.", e);
        }
        return null;
    }

    public static IPage createNodePage(IType modelType, ITypeHierarchy formFieldHierarchy) {
        return instance.createNodePageImpl(modelType, formFieldHierarchy);
    }

    private IPage createNodePageImpl(IType modelType, ITypeHierarchy formFieldHierarchy) {
        IFormFieldExtension[] iFormFieldExtensionArray = this.getSortedExtensions(modelType, formFieldHierarchy.getJdtHierarchy(), -1);
        int n = iFormFieldExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormFieldExtension ext = iFormFieldExtensionArray[n2];
            if (ext.getNodePage() != null) {
                return ext.createNodePage();
            }
            ++n2;
        }
        return null;
    }

    private IFormFieldExtension[] getSortedExtensions(IType modelType, org.eclipse.jdt.core.ITypeHierarchy formFieldHierarchy, int maxDistance) {
        ArrayList<IFormFieldExtension> extensions = new ArrayList<IFormFieldExtension>();
        for (IFormFieldExtension ext : this.m_extensions) {
            if (maxDistance < 0) {
                HashSet<IType> allSubTypes = new HashSet<IType>(Arrays.asList(formFieldHierarchy.getAllSubtypes(ext.getModelType())));
                allSubTypes.add(ext.getModelType());
                if (!allSubTypes.contains(modelType)) continue;
                extensions.add(ext);
                continue;
            }
            if (this.distanceToIFormField(modelType, ext.getModelType(), 0, formFieldHierarchy, maxDistance) > maxDistance) continue;
            extensions.add(ext);
        }
        return extensions.toArray(new IFormFieldExtension[extensions.size()]);
    }

    private void init() {
        IExtension[] extensions;
        TreeMap<CompositeObject, FormFieldExtension> formFieldExtensions = new TreeMap<CompositeObject, FormFieldExtension>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", "formField");
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                block16: {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("true".equalsIgnoreCase(element.getAttribute("active"))) {
                        String name = element.getAttribute("name");
                        String modClassName = element.getAttribute("model");
                        IType modelType = TypeUtility.getType((String)modClassName);
                        if (modelType == null) {
                            ScoutSdkUi.logError("FormFieldExtension: the model type '" + modClassName + "' can not be found.");
                            break;
                        }
                        if (modClassName == null) {
                            ScoutSdkUi.logWarning("Could not find model '" + modClassName + "'. Skiping this extension.");
                        } else {
                            Bundle contributerBundle;
                            Class<AbstractFormFieldWizard> wizardClazz;
                            org.eclipse.jdt.core.ITypeHierarchy superTypeHierarchy = null;
                            try {
                                superTypeHierarchy = modelType.newSupertypeHierarchy(null);
                            }
                            catch (JavaModelException e) {
                                ScoutSdkUi.logWarning("could not create super type hierarchy of '" + modelType.getFullyQualifiedName() + "'.", e);
                                break block16;
                            }
                            int distance = -this.distanceToIFormField(modelType, TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField"), 0, superTypeHierarchy);
                            CompositeObject key = new CompositeObject(new Object[]{distance, modelType.getFullyQualifiedName()});
                            FormFieldExtension formFieldExtension = (FormFieldExtension)formFieldExtensions.get(key);
                            if (formFieldExtension == null) {
                                formFieldExtension = new FormFieldExtension(name, modelType);
                                formFieldExtensions.put(key, formFieldExtension);
                            }
                            if ((wizardClazz = this.getClassOfContribution(contributerBundle = Platform.getBundle((String)extension.getNamespaceIdentifier()), element.getChildren("newWizard"), "wizard", AbstractFormFieldWizard.class)) != null) {
                                if (formFieldExtension.getNewWizardClazz() != null) {
                                    ScoutSdkUi.logWarning("double defined new wizard class.");
                                } else {
                                    formFieldExtension.setNewWizardClazz(wizardClazz);
                                }
                            }
                            String isInShortList = this.getAttributeOfContribution(contributerBundle, element.getChildren("newWizard"), "inShortList");
                            formFieldExtension.setInShortList("true".equalsIgnoreCase(isInShortList));
                            Class<AbstractScoutTypePage> nodePageClazz = this.getClassOfContribution(contributerBundle, element.getChildren("nodePage"), "nodePage", AbstractScoutTypePage.class);
                            if (nodePageClazz != null) {
                                if (formFieldExtension.getNodePage() != null) {
                                    ScoutSdkUi.logWarning("double defined node page class.");
                                } else {
                                    formFieldExtension.setNodePage(nodePageClazz);
                                }
                            }
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.m_extensions = new ArrayList<IFormFieldExtension>();
        for (IFormFieldExtension ext : formFieldExtensions.values()) {
            this.m_extensions.add(ext);
        }
        formFieldExtensions.clear();
    }

    private <T> Class<? extends T> getClassOfContribution(Bundle bundle, IConfigurationElement[] elements, String attribute, Class<T> t) {
        String clazzName;
        Class clazz = null;
        if (bundle != null && elements != null && elements.length == 1 && !StringUtility.isNullOrEmpty((String)(clazzName = elements[0].getAttribute(attribute)))) {
            try {
                clazz = bundle.loadClass(clazzName);
            }
            catch (Throwable tt) {
                ScoutSdkUi.logWarning("could not load class of extension '" + elements[0].getName() + "'.", tt);
            }
        }
        return clazz;
    }

    private String getAttributeOfContribution(Bundle bundle, IConfigurationElement[] elements, String attribute) {
        String value = null;
        if (bundle != null && elements != null && elements.length == 1) {
            value = elements[0].getAttribute(attribute);
        }
        return value;
    }

    private int distanceToIFormField(IType visitee, IType superType, int dist, org.eclipse.jdt.core.ITypeHierarchy superTypeHierarchy) throws IllegalArgumentException {
        return this.distanceToIFormField(visitee, superType, dist, superTypeHierarchy, Integer.MAX_VALUE);
    }

    private int distanceToIFormField(IType visitee, IType superType, int dist, org.eclipse.jdt.core.ITypeHierarchy superTypeHierarchy, int maxDistance) throws IllegalArgumentException {
        IType[] interfaces;
        if (visitee == null) {
            throw new IllegalArgumentException("try to determ the distance to IFormField of a instance not in subhierarchy of IFormField.");
        }
        if (dist > maxDistance) {
            return Integer.MAX_VALUE;
        }
        if (superType.getFullyQualifiedName().equals(visitee.getFullyQualifiedName())) {
            return dist;
        }
        int locDist = 100000;
        IType superclass = superTypeHierarchy.getSuperclass(visitee);
        if (superclass != null) {
            locDist = this.distanceToIFormField(superclass, superType, dist + 1, superTypeHierarchy, maxDistance);
        }
        if ((interfaces = superTypeHierarchy.getSuperInterfaces(visitee)) != null) {
            IType[] iTypeArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                IType i = iTypeArray[n2];
                locDist = Math.min(locDist, this.distanceToIFormField(i, superType, dist + 1, superTypeHierarchy, maxDistance));
                ++n2;
            }
        }
        dist = locDist;
        return dist;
    }
}

