/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.fields.code;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.extensions.ICodeIdParser;
import org.eclipse.scout.sdk.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.internal.extensions.CodeIdExtensionPoint;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CodeIdField
extends Composite {
    private StyledTextField m_nextCodeIdField;
    private ProposalTextField m_genericTypeField;
    private final IScoutBundle m_project;
    private final IProposalAdapterListener m_genericFieldListener;
    private final int m_labelPercentage;

    public CodeIdField(Composite parent, IScoutBundle project, int labelPercentage) {
        super(parent, 0);
        this.m_project = project;
        this.m_labelPercentage = labelPercentage;
        this.m_genericFieldListener = new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                CodeIdField.this.setCodeIdFieldState();
            }
        };
        this.createContent();
    }

    private void createContent() {
        this.m_nextCodeIdField = new FieldToolkit().createStyledTextField(this, Texts.get((String)"CodeId"), this.m_labelPercentage);
        this.setLayout((Layout)new GridLayout(1, false));
        this.m_nextCodeIdField.setLayoutData(new GridData(768));
    }

    private void setCodeIdFieldState() {
        boolean enabled = false;
        String sigProposal = this.getGenericSignature();
        if (sigProposal != null) {
            ICodeIdParser parser = CodeIdExtensionPoint.getCodeIdParser(sigProposal);
            boolean bl = enabled = parser != null;
        }
        if (enabled) {
            if (StringUtility.isNullOrEmpty((String)this.getValue())) {
                this.setValue(CodeIdExtensionPoint.getNextCodeId(this.m_project, this.getGenericSignature()));
            }
        } else {
            this.setValue(null);
        }
        this.m_nextCodeIdField.setEnabled(enabled);
    }

    private String getGenericSignature() {
        if (this.getGenericTypeField() != null && this.getGenericTypeField().getSelectedProposal() != null) {
            return (String)this.getGenericTypeField().getSelectedProposal();
        }
        return null;
    }

    public void addModifyListener(ModifyListener listener) {
        this.m_nextCodeIdField.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.m_nextCodeIdField.removeModifyListener(listener);
    }

    public IStatus getStatus() throws JavaModelException {
        if (this.getGenericSignature() != null && !StringUtility.isNullOrEmpty((String)this.getValue())) {
            ICodeIdParser parser = CodeIdExtensionPoint.getCodeIdParser(this.getGenericSignature());
            if (parser != null) {
                if (!parser.isValid(this.getValue())) {
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"CodeIdNotValid"));
                }
            } else {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"CodeIdNotValid"));
            }
        }
        return Status.OK_STATUS;
    }

    public void setValue(String nextCodeId) {
        this.m_nextCodeIdField.setText(nextCodeId);
    }

    public String getValue() {
        return this.m_nextCodeIdField.getText();
    }

    public String getValueSource() {
        ICodeIdParser parser;
        if (this.getGenericSignature() != null && !StringUtility.isNullOrEmpty((String)this.getValue()) && (parser = CodeIdExtensionPoint.getCodeIdParser(this.getGenericSignature())) != null) {
            return parser.getSource(this.getValue());
        }
        return null;
    }

    public void setGenericTypeField(ProposalTextField genericTypeField) {
        if (genericTypeField != this.m_genericTypeField) {
            if (this.m_genericTypeField != null) {
                this.m_genericTypeField.removeProposalAdapterListener(this.m_genericFieldListener);
            }
            this.m_genericTypeField = genericTypeField;
            this.m_genericTypeField.addProposalAdapterListener(this.m_genericFieldListener);
            this.setCodeIdFieldState();
        }
    }

    public ProposalTextField getGenericTypeField() {
        return this.m_genericTypeField;
    }
}

