/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import java.util.Arrays;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.form.formdata.ScoutBundlesUpdateFormDataOperation;
import org.eclipse.scout.sdk.ui.action.FormDataUpdateAction;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.OrganizeAllImportsAction;
import org.eclipse.scout.sdk.ui.action.create.ScoutBundleNewAction;
import org.eclipse.scout.sdk.ui.action.export.ExportScoutProjectAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNodeGroup;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class BundleNodeGroupTablePage
extends AbstractPage {
    private ScoutBundleNodeGroup m_group;

    public BundleNodeGroupTablePage(AbstractPage parentPage, ScoutBundleNodeGroup group) {
        this.m_group = group;
        this.setParent(parentPage);
        this.setName(group.getGroupName());
        ImageDescriptor icon = ScoutSdkUi.getImageDescriptor("projectGroup.png");
        if (group.isBinary()) {
            icon = ScoutSdkUi.getImageDescriptor(icon, "binary_decoration.png", 2);
        }
        this.setImageDescriptor(icon);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.BundleNodeGroupTablePage";
    }

    @Override
    public int getOrder() {
        return 10000;
    }

    @Override
    public IScoutBundle getScoutBundle() {
        return this.m_group.getDefiningBundle().getScoutBundle();
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{OrganizeAllImportsAction.class, FormDataUpdateAction.class, FormDataSqlBindingValidateAction.class, ExportScoutProjectAction.class, ScoutBundleNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof OrganizeAllImportsAction) {
            ((OrganizeAllImportsAction)menu).setScoutProject(this.getScoutBundle());
        } else if (menu instanceof FormDataUpdateAction) {
            ((FormDataUpdateAction)menu).setOperation((IOperation)new ScoutBundlesUpdateFormDataOperation(this.getScoutBundle()));
        } else if (menu instanceof FormDataSqlBindingValidateAction) {
            ((FormDataSqlBindingValidateAction)menu).setTyperesolver(new ITypeResolver(){

                @Override
                public IType[] getTypes() {
                    return BundleNodeGroupTablePage.this.resolveServices();
                }
            });
        } else if (menu instanceof ExportScoutProjectAction) {
            ((ExportScoutProjectAction)menu).setScoutProject(this.getScoutBundle());
        } else if (menu instanceof ScoutBundleNewAction) {
            ((ScoutBundleNewAction)menu).setScoutProject(this.getScoutBundle());
        }
    }

    protected IType[] resolveServices() {
        IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
        IPrimaryTypeTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iService);
        IScoutBundle[] serverBundles = this.getScoutBundle().getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}), true);
        IType[] services = serviceHierarchy.getAllSubtypes(iService, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])serverBundles));
        return services;
    }

    @Override
    public void loadChildrenImpl() {
        for (ScoutBundleNode b : this.m_group.getChildBundles()) {
            b.createBundlePage(this);
        }
        Object[] childGroups = this.m_group.getChildGroups().toArray(new ScoutBundleNodeGroup[this.m_group.getChildGroups().size()]);
        Arrays.sort(childGroups);
        Object[] objectArray = childGroups;
        int n = childGroups.length;
        int n2 = 0;
        while (n2 < n) {
            Object childGroup = objectArray[n2];
            new BundleNodeGroupTablePage(this, (ScoutBundleNodeGroup)childGroup);
            ++n2;
        }
    }
}

