/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerSettingsSupport;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutExplorerSettingsBundleFilter;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class ScoutBundleNode {
    private final String m_symbolicName;
    private final String m_type;
    private final Set<ScoutBundleNode> m_childNodes;
    private final ScoutBundleUiExtension m_uiExtension;
    private final IScoutBundle m_scoutBundle;

    public ScoutBundleNode(IScoutBundle bundle, ScoutBundleUiExtension uiExtension) {
        this.m_scoutBundle = bundle;
        this.m_symbolicName = bundle.getSymbolicName();
        this.m_type = bundle.getType();
        this.m_childNodes = new HashSet<ScoutBundleNode>();
        this.m_uiExtension = uiExtension;
        if (!ScoutExplorerSettingsSupport.BundlePresentation.Flat.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
            for (IScoutBundle child : bundle.getDirectChildBundles()) {
                ScoutBundleUiExtension childExt;
                if (!ScoutExplorerSettingsBundleFilter.get().accept(child) || (childExt = ScoutBundleExtensionPoint.getExtension(child.getType())) == null) continue;
                this.m_childNodes.add(new ScoutBundleNode(child, childExt));
            }
        }
    }

    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public String getType() {
        return this.m_type;
    }

    public void removeChildBundle(ScoutBundleNode node) {
        this.m_childNodes.remove(node);
    }

    public Set<ScoutBundleNode> getChildBundles() {
        return this.m_childNodes;
    }

    public boolean containsBundle(ScoutBundleNode node) {
        for (ScoutBundleNode child : this.getChildBundles()) {
            if (node.equals(child)) {
                return true;
            }
            if (!child.containsBundle(node)) continue;
            return true;
        }
        return false;
    }

    public IPage createBundlePage(IPage parentPage) {
        Class<? extends IPage> bundleNodePageClass = this.getUiExtension().getBundlePageClass();
        if (bundleNodePageClass != null) {
            try {
                Constructor<? extends IPage> constructor = bundleNodePageClass.getConstructor(IPage.class, ScoutBundleNode.class);
                return constructor.newInstance(parentPage, this);
            }
            catch (Exception e) {
                ScoutSdkUi.logError("Unable to create scout bundle table page.", e);
            }
        }
        return null;
    }

    public String toString() {
        return this.getSymbolicName();
    }

    public int hashCode() {
        return this.m_symbolicName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScoutBundleNode) {
            return CompareUtility.equals((Object)((ScoutBundleNode)obj).m_symbolicName, (Object)this.m_symbolicName);
        }
        return false;
    }

    public ScoutBundleUiExtension getUiExtension() {
        return this.m_uiExtension;
    }

    public IScoutBundle getScoutBundle() {
        return this.m_scoutBundle;
    }
}

