/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import java.util.Comparator;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.create.MenuNewAction;
import org.eclipse.scout.sdk.ui.action.delete.MemberListDeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.TypeRenameAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.TypeCacheAccessor;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeComparators;

public class MenuNodePage
extends AbstractScoutTypePage {
    private InnerTypePageDirtyListener m_menuChangedListener;

    public MenuNodePage(IPage parentPage, IType menuType) {
        super("Menu");
        this.setParent(parentPage);
        this.setType(menuType);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("menu.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.MenuNodePage";
    }

    @Override
    protected String getMethodNameForTranslatedText() {
        return "getConfiguredText";
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_menuChangedListener != null) {
            TypeCacheAccessor.getJavaResourceChangedEmitter().removeInnerTypeChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
            this.m_menuChangedListener = null;
        }
    }

    @Override
    public void loadChildrenImpl() {
        IType[] menus;
        IType iMenuType = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu");
        if (this.m_menuChangedListener == null) {
            this.m_menuChangedListener = new InnerTypePageDirtyListener(this, iMenuType);
            TypeCacheAccessor.getJavaResourceChangedEmitter().addInnerTypeChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
        }
        IType[] iTypeArray = menus = TypeUtility.getInnerTypes((IType)this.getType(), (ITypeFilter)TypeFilters.getSubtypeFilter((IType)iMenuType), (Comparator)ScoutTypeComparators.getOrderAnnotationComparator());
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            IType menu = iTypeArray[n2];
            new MenuNodePage(this, menu);
            ++n2;
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{TypeRenameAction.class, ShowJavaReferencesAction.class, MemberListDeleteAction.class, MenuNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        super.prepareMenuAction(menu);
        if (menu instanceof MemberListDeleteAction) {
            MemberListDeleteAction action = (MemberListDeleteAction)menu;
            action.addMemberToDelete((IMember)this.getType());
            action.setImage(ScoutSdkUi.getImageDescriptor("menu_remove.png"));
        } else if (menu instanceof MenuNewAction) {
            ((MenuNewAction)menu).setType(this.getType());
        }
    }
}

