/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformOutlinesOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.OutlineNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.OutlineNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class OutlineTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_outlineHierarchy;

    public OutlineTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"AllOutlinesTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("outlines.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_outlineHierarchy != null) {
            this.m_outlineHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_outlineHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_outlineHierarchy != null) {
            this.m_outlineHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.OutlineTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] outlines;
        IType iOutline = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
        if (this.m_outlineHierarchy == null) {
            this.m_outlineHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iOutline);
            this.m_outlineHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] iTypeArray = outlines = this.m_outlineHierarchy.getAllSubtypes(iOutline, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{this.getScoutBundle()}), TypeComparators.getTypeNameComparator());
        int n = outlines.length;
        int n2 = 0;
        while (n2 < n) {
            IType outline = iTypeArray[n2];
            new OutlineNodePage(this, outline);
            ++n2;
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{OutlineNewAction.class, WellformAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof OutlineNewAction) {
            ((OutlineNewAction)menu).init(this.getScoutBundle());
        } else if (menu instanceof WellformAction) {
            WellformAction action = (WellformAction)menu;
            action.setLabel(Texts.get((String)"WellformAllOutlines"));
            action.setScoutBundle(this.getScoutBundle());
            action.setOperation((IOperation)new WellformOutlinesOperation(this.getScoutBundle()));
        }
    }
}

