/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformWizardsOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.WizardNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class WizardTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_wizardHierarchy;

    public WizardTablePage(IPage parent) {
        this.setName(Texts.get((String)"WizardTablePage"));
        this.setParent(parent);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("wizzards.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_wizardHierarchy != null) {
            this.m_wizardHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_wizardHierarchy != null) {
            this.m_wizardHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.WizardTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] searchForms;
        IType iWizard = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.wizard.IWizard");
        if (this.m_wizardHierarchy == null) {
            this.m_wizardHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iWizard);
            this.m_wizardHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] iTypeArray = searchForms = this.m_wizardHierarchy.getAllSubtypes(iWizard, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{this.getScoutBundle()}), TypeComparators.getTypeNameComparator());
        int n = searchForms.length;
        int n2 = 0;
        while (n2 < n) {
            IType searchForm = iTypeArray[n2];
            new WizardNodePage(this, searchForm);
            ++n2;
        }
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof WellformAction) {
            WellformAction action = (WellformAction)menu;
            action.setScoutBundle(this.getScoutBundle());
            action.setLabel(Texts.get((String)"WellformAllWizards"));
            action.setOperation((IOperation)new WellformWizardsOperation(this.getScoutBundle()));
        } else if (menu instanceof WizardNewAction) {
            ((WizardNewAction)menu).setScoutResource(this.getScoutBundle());
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{WellformAction.class, WizardNewAction.class};
    }
}

