/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.ProcessServiceNewAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.ServerServicesNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class ServerServicesTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_serviceHierarchy;

    public ServerServicesTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("services.png"));
        this.setName(Texts.get((String)"ServerServicesNodePage"));
    }

    @Override
    public void unloadPage() {
        if (this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_serviceHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ServerServicesTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveServices();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType service = iTypeArray[n2];
            IType serviceInterface = null;
            IType[] interfaces = this.m_serviceHierarchy.getSuperInterfaces(service, TypeFilters.getElementNameFilter((String)("I" + service.getElementName())));
            if (interfaces.length > 0) {
                serviceInterface = interfaces[0];
            }
            new ServerServicesNodePage(this, service, serviceInterface);
            ++n2;
        }
    }

    protected IType[] resolveServices() {
        IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
        IType iSqlService = TypeUtility.getType((String)"org.eclipse.scout.rt.server.services.common.jdbc.ISqlService");
        IType iBookmarkStorageService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService");
        IType iCalendarService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.calendar.ICalendarService");
        IType iSMTPService = TypeUtility.getType((String)"org.eclipse.scout.rt.server.services.common.smtp.ISMTPService");
        IType iAccessControlService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.security.IAccessControlService");
        IType iLookupService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService");
        if (this.m_serviceHierarchy == null) {
            this.m_serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iService);
            this.m_serviceHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IScoutBundle sb = this.getScoutBundle();
        IType[] sqlServices = this.m_serviceHierarchy.getAllSubtypes(iSqlService, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{sb}));
        IType[] bookmarkServices = this.m_serviceHierarchy.getAllSubtypes(iBookmarkStorageService, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{sb}));
        IType[] calendarServices = this.m_serviceHierarchy.getAllSubtypes(iCalendarService, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{sb}));
        IType[] smtpServices = this.m_serviceHierarchy.getAllSubtypes(iSMTPService, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{sb}));
        IType[] accessControlServices = this.m_serviceHierarchy.getAllSubtypes(iAccessControlService, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{sb}));
        IType[] lookupServices = this.m_serviceHierarchy.getAllSubtypes(iLookupService, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{sb}));
        IType[] services = this.m_serviceHierarchy.getAllSubtypes(iService, TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{sb}), TypeFilters.getNotInTypes((IType[][])new IType[][]{sqlServices, bookmarkServices, calendarServices, smtpServices, accessControlServices, lookupServices})}), TypeComparators.getTypeNameComparator());
        return services;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{FormDataSqlBindingValidateAction.class, ProcessServiceNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof FormDataSqlBindingValidateAction) {
            ((FormDataSqlBindingValidateAction)menu).setTyperesolver(new ITypeResolver(){

                @Override
                public IType[] getTypes() {
                    return ServerServicesTablePage.this.resolveServices();
                }
            });
        } else if (menu instanceof ProcessServiceNewAction) {
            ((ProcessServiceNewAction)menu).setScoutBundle(this.getScoutBundle());
        }
    }
}

