/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.model.links;

import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.ILink;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinkGroup;

public class LinksPresenterModel {
    private HashMap<String, LinkGroup> m_groups = new HashMap();
    private LinkGroup m_globalLinks = new LinkGroup(Texts.get((String)"Global"), 0);

    public LinkGroup[] getOrderedNotEmtyGroups() {
        TreeSet<LinkGroup> orderedGroups = new TreeSet<LinkGroup>(new P_GroupComparator());
        for (LinkGroup group : this.m_groups.values()) {
            if (group.isEmpty()) continue;
            orderedGroups.add(group);
        }
        return orderedGroups.toArray(new LinkGroup[orderedGroups.size()]);
    }

    public LinkGroup getGroup(String name) {
        if (StringUtility.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("name can not be null.");
        }
        return this.m_groups.get(name);
    }

    public LinkGroup getOrCreateGroup(String name, int order) {
        if (StringUtility.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("name can not be null.");
        }
        LinkGroup linkGroup = this.m_groups.get(name);
        if (linkGroup == null) {
            linkGroup = new LinkGroup(name, order);
            this.m_groups.put(name, linkGroup);
        }
        return linkGroup;
    }

    public ILink[] getOrderdGlobalLinks() {
        return this.m_globalLinks.getLinks();
    }

    public void addGlobalLink(ILink link) {
        this.m_globalLinks.addLink(link);
    }

    public boolean isEmpty() {
        return this.getOrderedNotEmtyGroups().length == 0 && this.m_globalLinks.isEmpty();
    }

    private class P_GroupComparator
    implements Comparator<LinkGroup> {
        private P_GroupComparator() {
        }

        @Override
        public int compare(LinkGroup o1, LinkGroup o2) {
            if (o1.getOrder() == o2.getOrder()) {
                return o1.getName().compareTo(o2.getName());
            }
            return o1.getOrder() - o2.getOrder();
        }
    }
}

