/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.MethodOverrideOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.ExecMethodPresenter;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Composite;

public class ExecResetSearchFilterMethodPresenter
extends ExecMethodPresenter {
    public ExecResetSearchFilterMethodPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void overrideMethod() {
        if (!this.getMethod().isImplemented()) {
            try {
                P_OverrideExecResetSearchFilterMethod methodOverrideOperation = new P_OverrideExecResetSearchFilterMethod(this.getMethod().getType(), this.getMethod().getMethodName());
                OperationJob job = new OperationJob(new IOperation[]{methodOverrideOperation});
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (methodOverrideOperation.getCreatedMethod() != null) {
                    this.showJavaElementInEditor((IJavaElement)methodOverrideOperation.getCreatedMethod());
                }
            }
            catch (JavaModelException e) {
                ScoutSdkUi.logWarning("could not override the method '" + this.getMethod().getMethodName() + "' on '" + this.getMethod().getType() + "'", e);
            }
        }
    }

    private class P_OverrideExecResetSearchFilterMethod
    extends MethodOverrideOperation {
        private final IType iForm;
        private final IType iSearchForm;
        private IType m_formDataType;
        private IType m_formType;

        public P_OverrideExecResetSearchFilterMethod(IType declaringType, String methodName) throws JavaModelException {
            super(declaringType, methodName, true);
            this.iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
            this.iSearchForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
            this.m_formDataType = null;
            this.m_formType = declaringType;
            IPrimaryTypeTypeHierarchy formHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iForm);
            if (TypeUtility.exists((IJavaElement)this.m_formType) && formHierarchy.isSubtype(this.iSearchForm, this.m_formType)) {
                this.m_formDataType = ScoutTypeUtility.findFormDataForForm((IType)this.m_formType);
            }
        }

        protected String createMethodBody(IImportValidator validator) throws JavaModelException {
            if (this.m_formDataType != null && this.m_formType != null) {
                StringBuilder content = new StringBuilder();
                content.append("super.execResetSearchFilter(searchFilter);\n");
                String simpleFormDataName = validator.getTypeName(SignatureCache.createTypeSignature((String)this.m_formDataType.getFullyQualifiedName()));
                content.append(String.valueOf(simpleFormDataName) + " formData = new " + simpleFormDataName + "();\n");
                content.append("exportFormData(formData);\n");
                content.append("searchFilter.setFormData(formData);");
                return content.toString();
            }
            return super.createMethodBody(validator);
        }
    }
}

