/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.SearchRangeStyledLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class BorderDecorationPresenter
extends AbstractProposalPresenter<BorderDecoration> {
    private static final String BORDER_DECORATION_EMPTY = "empty";
    private static final String BORDER_DECORATION_LINE = "line";
    private static final String BORDER_DECORATION_SECTION = "section";
    private static final String BORDER_DECORATION_AUTO = "auto";

    public BorderDecorationPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        SearchRangeStyledLabelProvider labelProvider = new SearchRangeStyledLabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                return ScoutSdkUi.getImage("default.gif");
            }
        };
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        StaticContentProvider provider = new StaticContentProvider((Object[])BorderDecoration.values(), labelProvider);
        this.getProposalField().setContentProvider(provider);
    }

    @Override
    protected BorderDecoration parseInput(String input) throws CoreException {
        String parsedString = PropertyMethodSourceUtility.parseReturnParameterString((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        if (BORDER_DECORATION_EMPTY.equals(parsedString)) {
            return BorderDecoration.Empty;
        }
        if (BORDER_DECORATION_LINE.equals(parsedString)) {
            return BorderDecoration.Line;
        }
        if (BORDER_DECORATION_SECTION.equals(parsedString)) {
            return BorderDecoration.Section;
        }
        if (BORDER_DECORATION_AUTO.equals(parsedString)) {
            return BorderDecoration.Auto;
        }
        return null;
    }

    @Override
    protected synchronized void storeValue(BorderDecoration value) throws CoreException {
        if (value == null) {
            this.getProposalField().acceptProposal(this.getDefaultValue());
            value = (BorderDecoration)((Object)this.getDefaultValue());
        }
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((BorderDecoration)((Object)this.getDefaultValue()), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            StringBuilder source = new StringBuilder("return ");
            switch (value) {
                case Empty: {
                    source.append("BORDER_DECORATION_EMPTY");
                    break;
                }
                case Line: {
                    source.append("BORDER_DECORATION_LINE");
                    break;
                }
                case Section: {
                    source.append("BORDER_DECORATION_SECTION");
                    break;
                }
                case Auto: {
                    source.append("BORDER_DECORATION_AUTO");
                }
            }
            source.append(";");
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), source.toString(), true);
        }
        if (op != null) {
            new OperationJob(new IOperation[]{op}).schedule();
        }
    }

    protected static enum BorderDecoration {
        Empty,
        Line,
        Section,
        Auto;

    }
}

