/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ColorPresenter
extends AbstractValuePresenter<RGB> {
    private Canvas m_currentColorPresenter;
    private Color m_currentColor;
    private Button m_chooserButton;

    public ColorPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, ".*");
    }

    @Override
    public void dispose() {
        if (this.m_currentColor != null) {
            this.m_currentColor.dispose();
        }
        super.dispose();
    }

    @Override
    protected Control createContent(Composite container) {
        Composite rootPane = this.getToolkit().createComposite(container);
        this.m_currentColorPresenter = new P_ColorPresenter(rootPane);
        this.getToolkit().adapt((Composite)this.m_currentColorPresenter);
        GridData curValData = new GridData(22, 22);
        curValData.exclude = true;
        this.m_currentColorPresenter.setLayoutData((Object)curValData);
        Control text = super.createContent(rootPane);
        this.m_chooserButton = this.getToolkit().createButton(rootPane, "", 8);
        this.m_chooserButton.setImage(ScoutSdkUi.getImage("magnifier.png"));
        this.m_chooserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorPresenter.this.showColorChooser();
            }
        });
        GridLayout gLayout = new GridLayout(3, false);
        gLayout.horizontalSpacing = 3;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        rootPane.setLayout((Layout)gLayout);
        text.setLayoutData((Object)new GridData(768));
        this.m_chooserButton.setLayoutData((Object)new GridData(22, 22));
        return rootPane;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_chooserButton.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_chooserButton.getEnabled() && super.isEnabled();
        }
        return false;
    }

    @Override
    protected void execCurrentSourceValueChanged(RGB value) {
        if (this.m_currentColor != null) {
            this.m_currentColor.dispose();
            this.m_currentColor = null;
        }
        if (this.m_currentColorPresenter != null && !this.m_currentColorPresenter.isDisposed()) {
            if (value != null) {
                this.m_currentColor = new Color((Device)this.m_currentColorPresenter.getDisplay(), value);
                this.m_currentColorPresenter.setBackground(this.m_currentColor);
                ((GridData)this.m_currentColorPresenter.getLayoutData()).exclude = false;
                this.m_currentColorPresenter.setVisible(true);
                this.m_currentColorPresenter.getParent().layout(true);
            } else {
                ((GridData)this.m_currentColorPresenter.getLayoutData()).exclude = true;
                this.m_currentColorPresenter.setVisible(false);
                this.m_currentColorPresenter.getParent().layout(true);
            }
        }
    }

    private void showColorChooser() {
        ColorDialog colorDialog = new ColorDialog(this.getContainer().getShell());
        colorDialog.setRGB((RGB)this.getCurrentSourceValue());
        RGB rgb = colorDialog.open();
        if (rgb != null) {
            try {
                if (!CompareUtility.equals((Object)((RGB)this.getCurrentSourceValue()), (Object)rgb)) {
                    this.storeValue(rgb);
                }
            }
            catch (CoreException e1) {
                ScoutSdkUi.logWarning("could not parse RGB: " + rgb, e1);
            }
        }
    }

    @Override
    protected RGB parseSourceInput(String input) throws CoreException {
        String value = PropertyMethodSourceUtility.parseReturnParameterString((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        if (value == null) {
            value = "";
        }
        return this.parseDisplayInput(value);
    }

    @Override
    protected RGB parseDisplayInput(String input) throws CoreException {
        if (!input.matches("(|[A-Fa-f0-9]{6})")) {
            throw new CoreException((IStatus)new ScoutStatus(input));
        }
        if (input == null || input.length() == 0) {
            return null;
        }
        int i = Integer.parseInt(input, 16);
        return new RGB(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    @Override
    protected String formatSourceValue(RGB value) throws CoreException {
        if (value == null) {
            return "null";
        }
        String rgbSt = Integer.toHexString(value.red << 16 | value.green << 8 | value.blue);
        while (rgbSt.length() < 6) {
            rgbSt = "0" + rgbSt;
        }
        return "\"" + rgbSt.toUpperCase() + "\"";
    }

    @Override
    protected String formatDisplayValue(RGB value) throws CoreException {
        if (value == null) {
            return "";
        }
        String rgbSt = Integer.toHexString(value.red << 16 | value.green << 8 | value.blue);
        while (rgbSt.length() < 6) {
            rgbSt = "0" + rgbSt;
        }
        return rgbSt.toUpperCase();
    }

    @Override
    protected synchronized void storeValue(RGB value) throws CoreException {
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((RGB)this.getDefaultValue(), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + this.formatSourceValue(value) + ";", true);
        }
        if (op != null) {
            new OperationJob(new IOperation[]{op}).schedule();
        }
    }

    private class P_ColorPresenter
    extends Canvas {
        public P_ColorPresenter(Composite parent) {
            super(parent, 0);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    P_ColorPresenter.this.paint(e);
                }
            });
        }

        private void paint(PaintEvent e) {
            GC gc = e.gc;
            gc.setBackground(this.getDisplay().getSystemColor(2));
            gc.fillRoundRectangle(0, 0, this.getBounds().width, this.getBounds().height, 2, 2);
            gc.setBackground(this.getBackground());
            gc.fillRoundRectangle(1, 1, this.getBounds().width - 2, this.getBounds().height - 2, 2, 2);
        }
    }
}

