/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class VerticalAglinmentPresenter
extends AbstractProposalPresenter<VerticalAlignment> {
    public VerticalAglinmentPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                VerticalAlignment value = (VerticalAlignment)((Object)element);
                switch (value) {
                    case Top: {
                        return ScoutSdkUi.getImage("vertical_top.gif");
                    }
                    case Center: {
                        return ScoutSdkUi.getImage("vertical_center.gif");
                    }
                    case Bottom: {
                        return ScoutSdkUi.getImage("vertical_bottom.gif");
                    }
                }
                return null;
            }
        };
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        StaticContentProvider provider = new StaticContentProvider((Object[])VerticalAlignment.values(), (ILabelProvider)labelProvider);
        this.getProposalField().setContentProvider(provider);
    }

    @Override
    protected VerticalAlignment parseInput(String input) throws CoreException {
        int parsedInt = PropertyMethodSourceUtility.parseReturnParameterInteger((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        if (parsedInt < 0) {
            return VerticalAlignment.Top;
        }
        if (parsedInt == 0) {
            return VerticalAlignment.Center;
        }
        return VerticalAlignment.Bottom;
    }

    @Override
    protected synchronized void storeValue(VerticalAlignment value) throws CoreException {
        if (value == null) {
            this.getProposalField().acceptProposal(this.getDefaultValue());
            value = (VerticalAlignment)((Object)this.getDefaultValue());
        }
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((VerticalAlignment)((Object)this.getDefaultValue()), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            StringBuilder source = new StringBuilder("return ");
            switch (value) {
                case Top: {
                    source.append("-1");
                    break;
                }
                case Center: {
                    source.append("0");
                    break;
                }
                case Bottom: {
                    source.append("1");
                }
            }
            source.append(";");
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), source.toString(), true);
        }
        if (op != null) {
            new OperationJob(new IOperation[]{op}).schedule();
        }
    }

    protected static enum VerticalAlignment {
        Top,
        Center,
        Bottom;

    }
}

