/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.export;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.IFolderSelectedListener;
import org.eclipse.scout.sdk.ui.fields.IProductSelectionListener;
import org.eclipse.scout.sdk.ui.fields.ProductSelectionField;
import org.eclipse.scout.sdk.ui.fields.ResourceServletFolderSelectionField;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ExportClientWizardPage
extends AbstractWorkspaceWizardPage {
    private static final String SETTINGS_CLIENT_EXPORT_FOLDER = "clientExportFolderSetting";
    private static final String SETTINGS_PRODUCT_FILE_CLIENT = "clientProductFileSetting";
    private static final String PROP_CLIENT_EXPORT_FOLDER = "clientExportFolder";
    private static final String PROP_PRODUCT_FILE_CLIENT = "clientProductFile";
    private final IScoutBundle m_scoutProject;
    private IStatus m_clientProductStatus = Status.OK_STATUS;
    private IStatus m_clientExportFolderStatus = Status.OK_STATUS;
    private ProductSelectionField m_clientProductField;
    private ResourceServletFolderSelectionField m_resourceFolderField;

    public ExportClientWizardPage(IScoutBundle scoutProject) {
        super(ExportClientWizardPage.class.getName());
        this.m_scoutProject = scoutProject;
        this.setTitle(Texts.get((String)"ExportWebClientArchive"));
        this.setDescription(Texts.get((String)"WarExportDownloadClient"));
    }

    @Override
    protected void createContent(Composite parent) {
        ITreeNode clientProductTreeRoot = null;
        try {
            clientProductTreeRoot = TreeUtility.createProductTree(this.getScoutProject(), new P_ClientProductFilter(), false);
        }
        catch (CoreException e1) {
            ScoutSdkUi.logError("unable to create product file list", e1);
        }
        this.m_clientProductField = new ProductSelectionField(parent, clientProductTreeRoot);
        this.m_clientProductField.setLabelText(Texts.get((String)"ClientProductToInclude"));
        this.m_clientProductField.addProductSelectionListener(new IProductSelectionListener(){

            @Override
            public void productSelected(IFile productFile) {
                ExportClientWizardPage.this.setClientProductFileInternal(productFile);
                ExportClientWizardPage.this.pingStateChanging();
            }
        });
        IFile defaultSelection = this.getProductFileSetting();
        if (defaultSelection == null) {
            ITreeNode[] clientProductNodes = TreeUtility.findNodes(clientProductTreeRoot, NodeFilters.getByType("zz_product_node"));
            if (clientProductNodes.length == 1) {
                defaultSelection = (IFile)clientProductNodes[0].getData();
            } else if (clientProductNodes.length == 0) {
                this.m_clientProductStatus = new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoClientToAddAvail"));
            } else {
                defaultSelection = this.getDefaultSelectionProductFile(clientProductNodes);
            }
        }
        this.m_clientProductField.setProductFile(defaultSelection);
        this.setClientProductFileInternal(defaultSelection);
        this.m_resourceFolderField = new ResourceServletFolderSelectionField(parent, this.getScoutProject());
        this.m_resourceFolderField.setLabelText(Texts.get((String)"ClientDownloadLocation"));
        this.m_resourceFolderField.addProductSelectionListener(new IFolderSelectedListener(){

            @Override
            public void handleFolderSelection(IFolder folder) {
                ExportClientWizardPage.this.setClientExportFolderInternal(folder);
                ExportClientWizardPage.this.pingStateChanging();
            }
        });
        IFolder defaultFolder = this.getResourceFolderSetting();
        if (defaultFolder == null) {
            ITreeNode[] folderNodes = TreeUtility.findNodes(this.m_resourceFolderField.getRootNode(), NodeFilters.getByType("folder"));
            if (folderNodes.length == 1) {
                defaultFolder = (IFolder)folderNodes[0].getData();
            } else if (folderNodes.length == 0) {
                this.m_clientExportFolderStatus = new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoResourceServletFound"));
            }
        }
        this.m_resourceFolderField.setFolder(defaultFolder);
        this.setClientExportFolderInternal(defaultFolder);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_clientProductField.setLayoutData(new GridData(768));
        this.m_resourceFolderField.setLayoutData(new GridData(768));
    }

    private IFolder getResourceFolderSetting() {
        IFolder productFile;
        IProject project;
        Path p;
        String path = this.getDialogSettings().get(SETTINGS_CLIENT_EXPORT_FOLDER);
        if (StringUtility.hasText((String)path) && (p = new Path(path)).segmentCount() > 1 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p.segment(0))) != null && (productFile = project.getFolder(p.removeFirstSegments(1))) != null && productFile.exists()) {
            return productFile;
        }
        return null;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusClientProductField());
        multiStatus.add(this.getStatusClientExportFolder());
    }

    protected IStatus getStatusClientProductField() {
        if (this.m_clientProductStatus.isOK() && (this.getClientProductFile() == null || !this.getClientProductFile().exists())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoClientProductFileSpecified"));
        }
        return this.m_clientProductStatus;
    }

    protected IStatus getStatusClientExportFolder() {
        if (this.m_clientExportFolderStatus.isOK() && (this.getClientExportFolder() == null || !this.getClientExportFolder().exists())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoClientExportLocationSpecified"));
        }
        return this.m_clientExportFolderStatus;
    }

    public IScoutBundle getScoutProject() {
        return this.m_scoutProject;
    }

    public IFile getClientProductFile() {
        return (IFile)this.getProperty(PROP_PRODUCT_FILE_CLIENT);
    }

    public void setClientProductFile(IFile productFile) {
        try {
            this.setStateChanging(true);
            this.setClientProductFileInternal(productFile);
            if (this.isControlCreated()) {
                this.m_clientProductField.setProductFile(productFile);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setClientProductFileInternal(IFile productFile) {
        this.setProperty(PROP_PRODUCT_FILE_CLIENT, productFile);
        String setting = null;
        if (productFile != null) {
            setting = productFile.getFullPath().toString();
        }
        this.getDialogSettings().put(SETTINGS_PRODUCT_FILE_CLIENT, setting);
    }

    public IFolder getClientExportFolder() {
        return (IFolder)this.getProperty(PROP_CLIENT_EXPORT_FOLDER);
    }

    public void setClientExportFolder(IFolder folder) {
        try {
            this.setStateChanging(true);
            this.setClientExportFolderInternal(folder);
            if (this.isControlCreated()) {
                this.m_resourceFolderField.setFolder(folder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setClientExportFolderInternal(IFolder folder) {
        this.setProperty(PROP_CLIENT_EXPORT_FOLDER, folder);
        String setting = null;
        if (folder != null) {
            setting = folder.getFullPath().toString();
        }
        this.getDialogSettings().put(SETTINGS_CLIENT_EXPORT_FOLDER, setting);
    }

    private IFile getProductFileSetting() {
        IProject project;
        Path p;
        String path = this.getDialogSettings().get(SETTINGS_PRODUCT_FILE_CLIENT);
        if (!StringUtility.isNullOrEmpty((String)path) && (p = new Path(path)).segmentCount() > 1 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p.segment(0))) != null) {
            IFile productFile = project.getFile(p.removeFirstSegments(1));
            return productFile;
        }
        return null;
    }

    private IFile getDefaultSelectionProductFile(ITreeNode[] clientProductNodes) {
        IFile ret = null;
        int lastPrio = -1;
        ITreeNode[] iTreeNodeArray = clientProductNodes;
        int n = clientProductNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            IFile f = (IFile)n3.getData();
            int prio = 0;
            if (!f.getName().toLowerCase().contains("dev")) {
                ++prio;
            }
            if (f.getFullPath().toString().toLowerCase().contains("swt")) {
                ++prio;
            }
            if (prio > lastPrio) {
                ret = f;
                lastPrio = prio;
            }
            ++n2;
        }
        return ret;
    }

    private class P_ClientProductFilter
    implements ITreeNodeFilter {
        private P_ClientProductFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), "UI_SWING", "UI_SWT", "zz_product_node");
        }
    }
}

