/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.export;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.export.ExportEarOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.export.ExportScoutProjectEntry;
import org.eclipse.scout.sdk.ui.internal.wizard.export.ExportScoutProjectWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.export.IExportScoutProjectWizard;
import org.eclipse.scout.sdk.ui.wizard.export.IExportScoutProjectWizardPage;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.resources.ResourceFilters;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;

public class ExportScoutProjectWizard
extends AbstractWorkspaceWizard
implements IExportScoutProjectWizard {
    private static final Pattern ALIAS_REGEX = Pattern.compile(".*products.*/([^-]*)-.*.product");
    private final ExportScoutProjectWizardPage m_page1;
    private final IScoutBundle m_project;
    private final String m_projectAlias;

    public ExportScoutProjectWizard(IScoutBundle project) {
        this.m_project = project;
        this.m_projectAlias = this.findProjectAlias();
        this.m_page1 = new ExportScoutProjectWizardPage(project);
        this.setWindowTitle(Texts.get((String)"ExportScoutProject"));
        this.addPage((IWizardPage)this.m_page1);
    }

    @Override
    public IExportScoutProjectWizardPage getExportWizardPage() {
        return this.m_page1;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        ExportScoutProjectEntry[] selectedEntries = this.m_page1.getSelectedEntries();
        ArrayList<File> artifacts = new ArrayList<File>();
        ExportScoutProjectEntry[] exportScoutProjectEntryArray = selectedEntries;
        int n = selectedEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ExportScoutProjectEntry entry = exportScoutProjectEntryArray[n2];
            File module = entry.getHandler().createModule(this, monitor, workingCopyManager);
            if (module != null && module.exists()) {
                artifacts.add(module);
            }
            ++n2;
        }
        if (artifacts.size() > 0) {
            if (this.m_page1.isExportEar()) {
                ExportEarOperation op = new ExportEarOperation();
                op.addModule(artifacts.toArray(new File[artifacts.size()]));
                op.setEarFileName(new File(this.m_page1.getTargetDirectory(), this.m_page1.getEarName()).getAbsolutePath());
                op.validate();
                op.run(monitor, workingCopyManager);
            } else {
                for (File artifact : artifacts) {
                    try {
                        ResourceUtility.moveFile((File)artifact, (File)this.m_page1.getTargetDirectory());
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
                    }
                }
            }
            for (File artifact : artifacts) {
                artifact.getParentFile().delete();
            }
        }
        return true;
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    @Override
    public IScoutBundle getProject() {
        return this.m_project;
    }

    @Override
    public String getProjectAlias() {
        return this.m_projectAlias;
    }

    private String findProjectAlias() {
        try {
            IScoutBundle[] roots = this.getProject().getParentBundles(ScoutBundleFilters.getRootBundlesFilter(), true);
            HashMap<String, Integer> aliasList = new HashMap<String, Integer>();
            IScoutBundle[] iScoutBundleArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IScoutBundle root = iScoutBundleArray[n2];
                IScoutBundle[] iScoutBundleArray2 = root.getChildBundles(ScoutBundleFilters.getWorkspaceBundlesFilter(), true);
                int n3 = iScoutBundleArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource[] prodFiles;
                    IScoutBundle b = iScoutBundleArray2[n4];
                    IResource[] iResourceArray = prodFiles = ResourceUtility.getAllResources((IResource)b.getProject(), (IResourceFilter)ResourceFilters.getProductFilter());
                    int n5 = prodFiles.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IResource f = iResourceArray[n6];
                        String alias = this.getAliasFromProductFile((IFile)f);
                        if (alias != null) {
                            Integer i = (Integer)aliasList.get(alias);
                            if (i == null) {
                                i = 0;
                            }
                            i = i + 1;
                            aliasList.put(alias, i);
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            String ret = null;
            Integer last = null;
            for (Map.Entry entry : aliasList.entrySet()) {
                if (last != null && last >= (Integer)entry.getValue()) continue;
                ret = (String)entry.getKey();
                last = (Integer)entry.getValue();
            }
            return ret;
        }
        catch (CoreException e) {
            ScoutSdkUi.logWarning(e);
            return null;
        }
    }

    private String getAliasFromProductFile(IFile prodFile) {
        if (prodFile == null || !prodFile.exists()) {
            return null;
        }
        String path = prodFile.getFullPath().toString();
        Matcher m = ALIAS_REGEX.matcher(path);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }
}

