/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.export;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.wizard.export.AbstractExportProductWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.swt.widgets.Composite;

public class ExportServerWizardPage
extends AbstractExportProductWizardPage {
    private static final String SETTINGS_PRODUCT_FILE = "productFileSetting";
    private static final String SETTINGS_WAR_FILE_NAME = "warFileNameSetting";

    public ExportServerWizardPage(IScoutBundle scoutProject) {
        super(scoutProject, ExportServerWizardPage.class.getName(), Texts.get((String)"ExportWebArchive"), "SERVER", SETTINGS_PRODUCT_FILE, SETTINGS_WAR_FILE_NAME);
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        if (!StringUtility.hasText((String)this.m_warFileName.getModifiableText())) {
            String warName = this.findServerWarName();
            if (warName == null) {
                warName = String.valueOf(this.getWizard().getProjectAlias()) + "_server";
            }
            this.m_warFileName.setText(warName);
        }
    }

    private String findServerWarName() {
        IScoutBundle[] uiSwtBundles;
        IScoutBundle[] uiSwingBundles;
        IScoutBundle[] iScoutBundleArray = uiSwingBundles = this.getScoutProject().getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"UI_SWING"}), true);
        int n = uiSwingBundles.length;
        int n2 = 0;
        while (n2 < n) {
            String warName;
            IScoutBundle uiSwing = iScoutBundleArray[n2];
            if (uiSwing != null && !uiSwing.isBinary() && StringUtility.hasText((String)(warName = this.findServerNameInClientBundle(uiSwing)))) {
                return warName;
            }
            ++n2;
        }
        IScoutBundle[] iScoutBundleArray2 = uiSwtBundles = this.getScoutProject().getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"UI_SWT"}), true);
        int n3 = uiSwtBundles.length;
        n = 0;
        while (n < n3) {
            String warName;
            IScoutBundle uiSwt = iScoutBundleArray2[n];
            if (uiSwt != null && !uiSwt.isBinary() && StringUtility.hasText((String)(warName = this.findServerNameInClientBundle(uiSwt)))) {
                return warName;
            }
            ++n;
        }
        return null;
    }

    private String findServerNameInClientBundle(IScoutBundle bundle) {
        block2: {
            P_ConfigIniVisitor visitor = new P_ConfigIniVisitor();
            try {
                bundle.getProject().accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                if (!e.getStatus().isOK()) break block2;
                return visitor.getName();
            }
        }
        return null;
    }

    private static class P_ConfigIniVisitor
    implements IResourceVisitor {
        private static final Pattern SERVER_URL_PATTERN = Pattern.compile("\\/([^\\/]*)\\/process");
        private String m_name;

        private P_ConfigIniVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 && CompareUtility.equals((Object)"config.ini", (Object)resource.getName()) && resource.exists()) {
                this.parseConfigIniFile((IFile)resource);
            }
            return true;
        }

        private void parseConfigIniFile(IFile configIniFile) throws CoreException {
            block14: {
                Properties props = new Properties();
                InputStream is = null;
                try {
                    try {
                        is = configIniFile.getContents();
                        props.load(is);
                        String serverUrl = props.getProperty("server.url");
                        if (StringUtility.hasText((String)serverUrl)) {
                            Matcher m = SERVER_URL_PATTERN.matcher(serverUrl);
                            if (m.find()) {
                                this.m_name = m.group(1);
                            }
                            throw new CoreException(Status.OK_STATUS);
                        }
                    }
                    catch (IOException e) {
                        ScoutSdkUi.logError("could not parse file '" + configIniFile.getFullPath() + "'.", e);
                        if (is == null) break block14;
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public String getName() {
            return this.m_name;
        }
    }
}

