/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newbundle;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.wizard.project.AbstractProjectNewWizardPage;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ProductFileSelectionWizardPage
extends AbstractProjectNewWizardPage {
    private static final String PROP_SELECTED_PRODUCTS = "selectedProductFilesToModify";
    private final IScoutBundle m_bundle;
    private final Set<IFile> m_productFiles;
    private final List<ITreeNode> m_productNodes;
    private CheckableTree m_bundleTree;
    private ITreeNode m_invisibleRootNode;

    public ProductFileSelectionWizardPage(IScoutBundle project, Set<IFile> productFiles) {
        super(ProductFileSelectionWizardPage.class.getName());
        this.setTitle(Texts.get((String)"SelectProductsToModify"));
        this.setDescription(Texts.get((String)"ProductFileSelectionWizardMsg"));
        this.m_bundle = project;
        this.m_productFiles = productFiles;
        this.m_productNodes = new ArrayList<ITreeNode>();
    }

    @Override
    public void putProperties(PropertyMap properties) {
        ITreeNode[] checkedNodes = (ITreeNode[])this.getProperty(PROP_SELECTED_PRODUCTS);
        if (checkedNodes != null && checkedNodes.length > 0) {
            IFile[] prodFiles = new IFile[checkedNodes.length];
            int i = 0;
            while (i < checkedNodes.length) {
                prodFiles[i] = (IFile)checkedNodes[i].getData();
                ++i;
            }
            properties.setProperty("productFilesToExtend", (Object)prodFiles);
        }
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_invisibleRootNode = this.buildProductTree();
        this.m_bundleTree = new CheckableTree(parent, this.m_invisibleRootNode);
        this.m_bundleTree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                ProductFileSelectionWizardPage.this.setProperty(ProductFileSelectionWizardPage.PROP_SELECTED_PRODUCTS, ProductFileSelectionWizardPage.this.m_bundleTree.getCheckedNodes());
                ProductFileSelectionWizardPage.this.pingStateChanging();
            }
        });
        this.m_bundleTree.setChecked(this.m_productNodes.toArray(new ITreeNode[this.m_productNodes.size()]));
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_bundleTree.setLayoutData(new GridData(1808));
    }

    private ITreeNode buildProductTree() {
        this.m_productNodes.clear();
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setCheckable(false);
        rootNode.setVisible(false);
        for (IFile prodFile : this.m_productFiles) {
            IScoutBundle b = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundle(prodFile.getProject());
            if (b == null) continue;
            ITreeNode bundleNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(b));
            if (bundleNode == null) {
                bundleNode = TreeUtility.createBundleTreeNode(rootNode, b);
                bundleNode.setCheckable(false);
            }
            IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)prodFile.getAdapter(IWorkbenchAdapter.class);
            ImageDescriptor imageDescriptor = null;
            if (wbAdapter != null) {
                imageDescriptor = wbAdapter.getImageDescriptor((Object)prodFile);
            }
            ITreeNode childNode = TreeUtility.createNode(bundleNode, "zz_product_node", prodFile.getName(), imageDescriptor, 0, prodFile, false);
            childNode.setCheckable(true);
            bundleNode.addChild(childNode);
            this.m_productNodes.add(childNode);
        }
        return rootNode;
    }
}

