/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newbundle;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.project.IScoutProjectNewOperation;
import org.eclipse.scout.sdk.operation.project.add.ScoutProjectAddOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.wizard.newbundle.ProductFileSelectionWizardPage;
import org.eclipse.scout.sdk.ui.internal.wizard.newbundle.ScoutBundleAddWizardPage;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizard;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizardPage;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.resources.ResourceFilters;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.ui.IWorkbench;

public class ScoutBundleAddWizard
extends ScoutProjectNewWizard {
    private final ScoutBundleAddWizardPage m_page1;
    private ProductFileSelectionWizardPage m_page2;
    private final IScoutBundle m_scoutProject;

    public ScoutBundleAddWizard(IScoutBundle project) {
        this.setWindowTitle(Texts.get((String)"CreateNewScoutBundles"));
        this.m_scoutProject = project;
        this.m_page1 = new ScoutBundleAddWizardPage(project);
        this.addPage((IWizardPage)this.m_page1);
        Set<IFile> productFiles = ScoutBundleAddWizard.getProductFiles(project.getSymbolicName());
        if (productFiles.size() > 0) {
            this.m_page2 = new ProductFileSelectionWizardPage(project, productFiles);
            this.addPage((IWizardPage)this.m_page2);
        }
    }

    public static Set<IFile> getProductFiles(String dependencyFilter) {
        LinkedHashSet<IFile> productFiles = new LinkedHashSet<IFile>();
        try {
            IResource[] iResourceArray = ResourceUtility.getAllResources((IResourceFilter)ResourceFilters.getProductFilter());
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource f = iResourceArray[n2];
                IFile prodFile = (IFile)f;
                if (ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundle(prodFile.getProject()) != null) {
                    ProductFileModelHelper h = new ProductFileModelHelper(prodFile);
                    if (h.ProductFile.existsDependency(dependencyFilter)) {
                        productFiles.add((IFile)f);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("Unable to retrieve possible product files to modify.", e);
        }
        return productFiles;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    @Override
    public boolean performFinish() {
        new P_FinishJob().schedule();
        return true;
    }

    @Override
    public IScoutProjectWizardPage getProjectWizardPage() {
        return this.m_page1;
    }

    @Override
    public IScoutBundle getScoutProject() {
        return this.m_scoutProject;
    }

    private class P_FinishJob
    extends ScoutProjectNewWizard.P_PerformFinishJob {
        public P_FinishJob() {
            super(ScoutBundleAddWizard.this, ScoutBundleAddWizard.this.getContainer().getShell().getDisplay());
        }

        @Override
        protected void switchPerspective() {
        }

        @Override
        protected IScoutProjectNewOperation getFinishOperation() {
            return new ScoutProjectAddOperation(ScoutBundleAddWizard.this.getScoutProject());
        }
    }
}

