/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.commons.xmlparser.ScoutXmlParser;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.osgi.framework.Bundle;

public class PropertyViewConfig {
    private static final String TAG_TYPE = "type";
    private static final String TAG_CONFIG = "config";
    private static final String PROP_TYPE_NAME = "name";
    private static final String PROP_CONFIG_NAME = "name";
    private static final String PROP_CONFIG_TYPE = "type";
    private static final String PROP_CONFIG_CATEGORY = "category";
    private static final String PROP_CONFIG_ORDER = "order";
    private final HashMap<String, HashMap<String, Config>> m_typeConfigs = new HashMap(100);
    public static final ConfigTypes DEFAULT_CONFIG_TYPE = ConfigTypes.Advanced;
    public static final ConfigCategory DEFAULT_CONFIG_CATEGORY = ConfigCategory.Misc;

    public PropertyViewConfig() {
        this.load();
    }

    private void load() {
        try {
            URL url = FileLocator.find((Bundle)ScoutSdkUi.getDefault().getBundle(), (IPath)new Path("resources/sdkPropertyViewConfig.xml"), null);
            ScoutXmlParser parser = new ScoutXmlParser();
            InputStream is = null;
            try {
                is = url.openStream();
                ScoutXmlDocument xmlDoc = parser.parse(is);
                for (ScoutXmlDocument.ScoutXmlElement o : xmlDoc.getRoot().getChildren("type")) {
                    this.loadType(o);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logError("unable to load property view configuration. ", e);
        }
    }

    public Config getConfiguration(ConfigurationMethod m) {
        IType[] superTypes;
        IType[] iTypeArray = superTypes = m.getSuperTypeHierarchy().getAllSupertypes(m.getType());
        int n = superTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Config c;
            IType superType = iTypeArray[n2];
            HashMap<String, Config> tc = this.m_typeConfigs.get(superType.getFullyQualifiedName());
            if (tc != null && (c = tc.get(m.getMethodName())) != null) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    private void loadType(ScoutXmlDocument.ScoutXmlElement type) {
        if (type == null) {
            return;
        }
        String name = type.getAttribute("name");
        if (name == null || name.trim().length() < 1) {
            return;
        }
        HashMap<String, Config> c = new HashMap<String, Config>(20);
        this.m_typeConfigs.put(name, c);
        for (ScoutXmlDocument.ScoutXmlElement o : type.getChildren(TAG_CONFIG)) {
            this.loadConfig(c, o);
        }
    }

    private ConfigTypes parseConfigType(String type) {
        try {
            ConfigTypes ret = ConfigTypes.valueOf(type);
            if (ret == null) {
                ret = DEFAULT_CONFIG_TYPE;
            }
            return ret;
        }
        catch (Exception e) {
            return DEFAULT_CONFIG_TYPE;
        }
    }

    private ConfigCategory parseConfigCategory(String cat) {
        try {
            ConfigCategory ret = ConfigCategory.valueOf(cat);
            if (ret == null) {
                ret = DEFAULT_CONFIG_CATEGORY;
            }
            return ret;
        }
        catch (Exception e) {
            return DEFAULT_CONFIG_CATEGORY;
        }
    }

    private Double parseOrder(String order) {
        block3: {
            try {
                if (order != null && order.trim().length() >= 1) break block3;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return Double.parseDouble(order);
    }

    private void loadConfig(HashMap<String, Config> tc, ScoutXmlDocument.ScoutXmlElement config) {
        if (config == null) {
            return;
        }
        String name = config.getAttribute("name");
        String type = config.getAttribute("type", ConfigTypes.Advanced.toString());
        String category = config.getAttribute(PROP_CONFIG_CATEGORY, ConfigCategory.Misc.toString());
        String order = config.getAttribute(PROP_CONFIG_ORDER, null);
        Config c = new Config();
        c.category = this.parseConfigCategory(category);
        c.type = this.parseConfigType(type);
        c.order = this.parseOrder(order);
        tc.put(name, c);
    }

    public static class Config {
        private ConfigTypes type;
        private ConfigCategory category;
        private Double order;

        public Double getOrder() {
            return this.order;
        }

        public ConfigTypes getType() {
            return this.type;
        }

        public ConfigCategory getCategory() {
            return this.category;
        }
    }

    public static enum ConfigCategory {
        Appearance(100),
        Layout(200),
        Behavior(300),
        Data(400),
        BusinessLogic(500),
        Misc(Integer.MAX_VALUE);

        private final int m_order;
        private final String m_name;

        private ConfigCategory(int order) {
            this.m_order = order;
            this.m_name = Texts.get((String)("PropertyViewConfig.Categories." + this.toString()));
        }

        public int getOrder() {
            return this.m_order;
        }

        public String getLabel() {
            return this.m_name;
        }
    }

    public static enum ConfigTypes {
        Normal,
        Advanced;

    }
}

