/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinkGroup;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.TypeOpenLink;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.LinksPresenter;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.server.service.AbstractServiceNodePage;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.JdtTypePropertyPart;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ServicePropertyPart
extends JdtTypePropertyPart {
    private static final String SECTION_ID_LINKS = "section.links";
    private final IType basicPermission = TypeUtility.getType((String)"java.security.BasicPermission");
    private final IType iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");

    @Override
    protected void createSections() {
        ISection linkSection = this.createSection(SECTION_ID_LINKS, Texts.get((String)"Links"));
        this.fillLinkSection(linkSection.getSectionClient());
        linkSection.setExpanded(this.wasSectionExpanded(SECTION_ID_LINKS, true));
        super.createSections();
    }

    @Override
    public AbstractServiceNodePage getPage() {
        return (AbstractServiceNodePage)super.getPage();
    }

    protected void fillLinkSection(Composite parent) {
        String entityName = null;
        LinksPresenterModel model = new LinksPresenterModel();
        if (this.getPage().getInterfaceType() != null) {
            model.addGlobalLink(new TypeOpenLink(this.getPage().getInterfaceType()));
        }
        if (this.getPage().getType() != null) {
            model.addGlobalLink(new TypeOpenLink(this.getPage().getType()));
            entityName = this.findEntityName(this.getPage().getType().getElementName());
        }
        if (!StringUtility.isNullOrEmpty(entityName)) {
            int n;
            if (TypeUtility.exists((IJavaElement)this.iForm) && this.getPage().getInterfaceType() != null) {
                String formRegex = String.valueOf(entityName) + "Form";
                IScoutBundle interfaceBundle = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundle((IJavaElement)this.getPage().getInterfaceType());
                ITypeFilter formFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getRegexSimpleNameFilter((String)formRegex), TypeFilters.getClassFilter(), ScoutTypeFilters.getInScoutBundles((IScoutBundle[])interfaceBundle.getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}), false))});
                LinkGroup formGroup = model.getOrCreateGroup(Texts.get((String)"Form"), 10);
                IType[] iTypeArray = TypeUtility.getPrimaryTypeHierarchy((IType)this.iForm).getAllSubtypes(this.iForm, formFilter, TypeComparators.getTypeNameComparator());
                int n2 = iTypeArray.length;
                n = 0;
                while (n < n2) {
                    IType candidate = iTypeArray[n];
                    formGroup.addLink(new TypeOpenLink(candidate));
                    ++n;
                }
            }
            String permissionRegex = "(Create|Read|Update)" + entityName + "Permission";
            ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getRegexSimpleNameFilter((String)permissionRegex), TypeFilters.getClassFilter(), ScoutTypeFilters.getInScoutBundles((IScoutBundle[])this.getPage().getScoutBundle().getParentBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false))});
            LinkGroup permissionGroup = model.getOrCreateGroup(Texts.get((String)"PermissionTablePage"), 20);
            IType[] iTypeArray = TypeUtility.getPrimaryTypeHierarchy((IType)this.basicPermission).getAllSubtypes(this.basicPermission, filter, TypeComparators.getTypeNameComparator());
            n = iTypeArray.length;
            int n3 = 0;
            while (n3 < n) {
                IType candidate = iTypeArray[n3];
                permissionGroup.addLink(new TypeOpenLink(candidate));
                ++n3;
            }
        }
        LinksPresenter presenter = new LinksPresenter(this.getFormToolkit(), parent, model);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        presenter.getContainer().setLayoutData((Object)layoutData);
    }

    private String findEntityName(String serviceName) {
        if (StringUtility.isNullOrEmpty((String)serviceName)) {
            return serviceName;
        }
        if (serviceName.endsWith("AccessControlService")) {
            return serviceName.replaceAll("^(.*)AccessControlService$", "$1");
        }
        if (serviceName.endsWith("BookmarkStorageService")) {
            return serviceName.replaceAll("^(.*)BookmarkStorageService$", "$1");
        }
        if (serviceName.endsWith("LookupService")) {
            return serviceName.replaceAll("^(.*)LookupService$", "$1");
        }
        if (serviceName.endsWith("CalendarService")) {
            return serviceName.replaceAll("^(.*)CalendarService$", "$1");
        }
        if (serviceName.endsWith("SmtpService")) {
            return serviceName.replaceAll("^(.*)SmtpService$", "$1");
        }
        if (serviceName.endsWith("SqlService")) {
            return serviceName.replaceAll("^(.*)SqlService$", "$1");
        }
        if (serviceName.endsWith("Service")) {
            return serviceName.replaceAll("^(.*)Service$", "$1");
        }
        return serviceName;
    }
}

