/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractTypeProposalPresenter
extends AbstractProposalPresenter<IType> {
    public AbstractTypeProposalPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected IType parseInput(String input) throws CoreException {
        IType referedType = PropertyMethodSourceUtility.parseReturnParameterClass((String)input, (IMethod)this.getMethod().peekMethod());
        return referedType;
    }

    @Override
    protected synchronized void storeValue(final IType value) throws CoreException {
        Object op = null;
        if (UiUtility.equals((IType)this.getDefaultValue(), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName()){

                protected String createMethodBody(IMethod methodToOverride, IImportValidator validator) throws JavaModelException {
                    StringBuilder source = new StringBuilder();
                    source.append("  return ");
                    if (value != null) {
                        source.append(String.valueOf(SignatureUtility.getTypeReference((String)SignatureCache.createTypeSignature((String)value.getFullyQualifiedName()), (IImportValidator)validator)) + ".class;");
                    } else {
                        source.append("null;");
                    }
                    return source.toString();
                }
            };
            ((ConfigPropertyMethodUpdateOperation)op).setFormatSource(true);
        }
        new OperationJob(new IOperation[]{op}).schedule();
    }
}

