/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.code;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.CodeNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.CodeIdExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.fields.code.CodeIdField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CodeNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iCode = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICode");
    private String m_nextCodeId;
    private String m_nextCodeIdSource;
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private String m_genericSignature;
    private SiblingProposal m_sibling;
    private CodeIdField m_nextCodeIdField;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_genericTypeField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private final IScoutBundle m_bundle;
    private IType m_createdCode;

    public CodeNewWizardPage(IType declaringType) {
        super(CodeNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewCode"));
        this.setDescription(Texts.get((String)"CreateANewCode"));
        this.m_declaringType = declaringType;
        this.m_bundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType.getJavaProject());
        this.m_superType = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.shared.services.common.code.ICode", (IJavaProject)this.m_declaringType.getJavaProject());
        this.m_genericSignature = SignatureCache.createTypeSignature((String)Long.class.getName());
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    public void postActivate() {
        this.m_nlsNameField.setFocus();
    }

    @Override
    protected void createContent(Composite parent) {
        int labelColWidthPercent = 20;
        IScoutBundle project = ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType.getJavaProject());
        this.m_nextCodeIdField = new CodeIdField(parent, project, labelColWidthPercent);
        this.m_nextCodeIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeNewWizardPage.this.m_nextCodeId = CodeNewWizardPage.this.m_nextCodeIdField.getValue();
                CodeNewWizardPage.this.m_nextCodeIdSource = CodeNewWizardPage.this.m_nextCodeIdField.getValueSource();
                CodeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"Name"), labelColWidthPercent);
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = CodeNewWizardPage.this.getNlsName();
                    CodeNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (CodeNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(CodeNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)CodeNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        CodeNewWizardPage.this.m_typeNameField.setText(CodeNewWizardPage.this.m_nlsName.getKey());
                    }
                }
                finally {
                    CodeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix("Code");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeNewWizardPage.this.m_typeName = CodeNewWizardPage.this.m_typeNameField.getText();
                CodeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                return new Object[][]{TypeUtility.toArray((IType[])new IType[]{CodeNewWizardPage.this.m_declaringType}), ScoutTypeUtility.getCodes((IType)CodeNewWizardPage.this.m_declaringType)};
            }
        }, labelColWidthPercent);
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeNewWizardPage.this.setStateChanging(true);
                    CodeNewWizardPage.this.m_superType = (IType)event.proposal;
                    if (TypeUtility.isGenericType((IType)CodeNewWizardPage.this.getSuperType())) {
                        CodeNewWizardPage.this.m_genericTypeField.setEnabled(true);
                        if (CodeNewWizardPage.this.getGenericSignature() == null) {
                            CodeNewWizardPage.this.m_genericTypeField.acceptProposal(TypeUtility.getType((String)Long.class.getName()));
                        }
                    } else {
                        CodeNewWizardPage.this.m_genericTypeField.setEnabled(false);
                    }
                }
                finally {
                    CodeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_genericTypeField = this.getFieldToolkit().createSignatureProposalField(parent, Texts.get((String)"GenericType"), ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType), SignatureProposalProvider.DEFAULT_PRIMITIV_SIGNATURES, labelColWidthPercent);
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeNewWizardPage.this.setStateChanging(true);
                    CodeNewWizardPage.this.m_genericSignature = (String)event.proposal;
                    if (CodeNewWizardPage.this.m_genericSignature != null && CodeNewWizardPage.this.getNextCodeId() == null) {
                        CodeNewWizardPage.this.setNextCodeId(CodeIdExtensionPoint.getNextCodeId(CodeNewWizardPage.this.m_bundle, CodeNewWizardPage.this.getGenericSignature()));
                    }
                }
                finally {
                    CodeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_siblingField = this.getFieldToolkit().createSiblingProposalField(parent, this.m_declaringType, this.iCode, labelColWidthPercent);
        this.m_siblingField.acceptProposal(this.m_sibling);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                CodeNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                CodeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_nextCodeIdField.setGenericTypeField(this.m_genericTypeField);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nextCodeIdField.setLayoutData(new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        CodeNewOperation op = new CodeNewOperation(this.m_declaringType, true);
        op.setNlsEntry(this.getNlsName());
        op.setTypeName(this.getTypeName());
        IType superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            String sig = null;
            sig = this.getGenericSignature() != null ? SignatureCache.createTypeSignature((String)(String.valueOf(superTypeProp.getFullyQualifiedName()) + "<" + Signature.toString((String)this.getGenericSignature()) + ">")) : SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName());
            op.setSuperTypeSignature(sig);
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredCodeType((IType)this.m_declaringType);
            op.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_CODE));
        } else {
            op.setSibling(this.getSibling().getElement());
        }
        op.setGenericTypeSignature(this.getGenericSignature());
        op.setNextCodeId(this.getNextCodeIdSource());
        op.run(monitor, workingCopyManager);
        this.m_createdCode = op.getCreatedCode();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusCodeIdField());
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusGenericType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusCodeIdField() throws JavaModelException {
        if (this.isControlCreated()) {
            return this.m_nextCodeIdField.getStatus();
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Code")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_className"));
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericType() throws JavaModelException {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public void setNextCodeId(String nextCodeId) {
        try {
            this.setStateChanging(true);
            this.m_nextCodeId = nextCodeId;
            if (this.isControlCreated()) {
                this.m_nextCodeIdField.setValue(nextCodeId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getNextCodeId() {
        return this.m_nextCodeId;
    }

    public String getNextCodeIdSource() {
        return this.m_nextCodeIdSource;
    }

    public IType getCreatedCode() {
        return this.m_createdCode;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setGenericSignature(String genericType) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericType;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getGenericSignature() {
        return this.m_genericSignature;
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

