/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.library;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleComparators;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class JavaProjectSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = JavaProjectSelectionDialog.class.getName();
    private IJavaProject[] m_javaProjects;

    public JavaProjectSelectionDialog(Shell shell, boolean includeFragments, boolean multiSelect) {
        this(shell, JavaProjectSelectionDialog.getAllWorkspaceScoutProjects(includeFragments), multiSelect);
    }

    public JavaProjectSelectionDialog(Shell shell, IJavaProject[] projects, boolean multiSelect) {
        super(shell, multiSelect);
        this.setListLabelProvider((ILabelProvider)new JavaElementLabelProvider());
        this.setDetailsLabelProvider((ILabelProvider)new JavaElementLabelProvider());
        this.setInitialPattern("**");
        this.setHelpAvailable(false);
        this.m_javaProjects = projects;
    }

    public static IJavaProject[] getAllWorkspaceScoutProjects(boolean includeFragments) {
        IScoutBundle[] bundles = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getWorkspaceBundlesFilter(), ScoutBundleComparators.getSymbolicNameAscComparator());
        ArrayList<IJavaProject> plugins = new ArrayList<IJavaProject>(bundles.length);
        IScoutBundle[] iScoutBundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle project = iScoutBundleArray[n2];
            try {
                if (!project.getProject().hasNature("org.eclipse.scout.sdk.ScoutLibraryNature")) {
                    plugins.add(project.getJavaProject());
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logWarning("could not validate plugin '" + project.getSymbolicName() + "'.", e);
            }
            ++n2;
        }
        return plugins.toArray(new IJavaProject[plugins.size()]);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public int open() {
        return super.open();
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new P_JavaProjectSearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        IJavaProject[] iJavaProjectArray = this.m_javaProjects;
        int n = this.m_javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            contentProvider.add((Object)project, itemsFilter);
            progressMonitor.worked(1);
            ++n2;
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = ScoutSdkUi.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = ScoutSdkUi.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IJavaProject) {
            return ((IJavaProject)item).getElementName();
        }
        return null;
    }

    protected Comparator getItemsComparator() {
        return new P_JavaProjectSearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.scout.sdk.ui", 0, "", null);
    }

    private class P_JavaProjectSearchComparator
    implements Comparator {
        private P_JavaProjectSearchComparator() {
        }

        public int compare(Object o1, Object o2) {
            int id2;
            int id1 = this.getId(o1);
            if (id1 != (id2 = this.getId(o2))) {
                return id1 - id2;
            }
            return this.compareSimilarObjects(o1, o2);
        }

        private int getId(Object element) {
            if (element instanceof IJavaProject) {
                return 100;
            }
            return 0;
        }

        private int compareSimilarObjects(Object o1, Object o2) {
            if (o1 instanceof IJavaProject && o2 instanceof IJavaProject) {
                IJavaProject ipmb1 = (IJavaProject)o1;
                IJavaProject ipmb2 = (IJavaProject)o2;
                return ipmb1.getElementName().compareTo(ipmb2.getElementName());
            }
            return 0;
        }
    }

    private class P_JavaProjectSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private P_JavaProjectSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)JavaProjectSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String id = null;
            if (item instanceof IJavaProject) {
                IJavaProject project = (IJavaProject)item;
                id = project.getElementName();
            }
            return this.matches(id);
        }

        protected boolean matches(String text) {
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf("*") != 0 & pattern.indexOf("?") != 0 & pattern.indexOf(".") != 0) {
                pattern = "*" + pattern;
                this.patternMatcher.setPattern(pattern);
            }
            return this.patternMatcher.matches(text);
        }
    }
}

