/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.lookupcall;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.lookupcall.LocalLookupCallNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.lookupcall.LocalLookupCallNewWizard;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.validation.JavaElementValidator;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class LocalLookupCallNewWizardPage
extends AbstractWorkspaceWizardPage {
    protected final IType localLookupCall = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall");
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private EntityTextField m_entityField;
    private IScoutBundle m_clientBundle;

    public LocalLookupCallNewWizardPage(IScoutBundle client) {
        super(LocalLookupCallNewWizardPage.class.getName());
        this.m_clientBundle = client;
        this.setTitle(Texts.get((String)"NewLocalLookupCallNoPopup"));
        this.setDescription(Texts.get((String)"CreateANewLocalLookupCall"));
        this.setLookupCallSuperTypeInternal(this.localLookupCall);
        this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)client, (String)"client.services.lookup"));
    }

    @Override
    protected void createContent(Composite parent) {
        int labelColWidthPercent = 20;
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix("LookupCall");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalLookupCallNewWizardPage.this.setTypeNameInternal(LocalLookupCallNewWizardPage.this.m_typeNameField.getText());
                LocalLookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"LookupCallSuperType"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)LocalLookupCallNewWizardPage.this.getClientBundle().getJavaProject()), TypeFilters.getNotInTypes((IType[])new IType[]{LocalLookupCallNewWizardPage.this.localLookupCall})});
                IPrimaryTypeTypeHierarchy lookupServiceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)LocalLookupCallNewWizardPage.this.localLookupCall);
                return new Object[][]{TypeUtility.toArray((IType[])new IType[]{LocalLookupCallNewWizardPage.this.localLookupCall}), lookupServiceHierarchy.getAllClasses(filter, TypeComparators.getTypeNameComparator())};
            }
        }, labelColWidthPercent);
        this.m_superTypeField.acceptProposal(this.getLookupCallSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                LocalLookupCallNewWizardPage.this.setLookupCallSuperTypeInternal((IType)event.proposal);
                LocalLookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField(parent, Texts.get((String)"EntityTextField"), this.m_clientBundle, labelColWidthPercent);
            this.m_entityField.setText(this.getTargetPackage());
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LocalLookupCallNewWizardPage.this.setTargetPackageInternal(LocalLookupCallNewWizardPage.this.m_entityField.getText());
                    LocalLookupCallNewWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
        }
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
    }

    public LocalLookupCallNewWizard getWizard() {
        return (LocalLookupCallNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusTargetPackge());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager manager) throws CoreException {
        LocalLookupCallNewOperation op = new LocalLookupCallNewOperation();
        op.setBundle(this.getClientBundle());
        op.setLookupCallName(this.getTypeName());
        op.setPackageName(this.getClientBundle().getPackageName(this.getTargetPackage()));
        op.setFormatSource(true);
        IType superTypeProp = this.getLookupCallSuperType();
        if (superTypeProp != null) {
            op.setLookupCallSuperTypeSignature(SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName()));
        }
        op.validate();
        op.run(monitor, manager);
        return true;
    }

    protected IStatus getStatusTargetPackge() {
        return JavaElementValidator.validatePackageName((String)this.getTargetPackage());
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("LookupCall")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_className"));
        }
        if (TypeUtility.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(this.getTargetPackage())) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getLookupCallSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getLookupCallSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setLookupCallSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setLookupCallSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLookupCallSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public String getTargetPackage() {
        return (String)this.getProperty(PROP_TARGET_PACKAGE);
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.setProperty(PROP_TARGET_PACKAGE, targetPackage);
    }
}

