/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.lookupcall;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.lookupcall.LookupCallNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.lookupcall.LookupCallNewWizardPage;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class LookupCallNewWizard
extends AbstractWorkspaceWizard {
    public static final String TYPE_LOOKUPCALL = "lookupCall";
    public static final String TYPE_SERVICE_INTERFACE = "svcIfc";
    public static final String TYPE_SERVICE_IMPLEMENTATION = "svcImpl";
    public static final String TYPE_SERVICE_REG_CLIENT = "svcRegClient";
    public static final String TYPE_SERVICE_REG_SERVER = "svcRegServer";
    private final IScoutBundle m_sharedBundle;
    private LookupCallNewWizardPage m_page1;
    private BundleTreeWizardPage m_page2;
    private LookupCallNewOperation m_operation;
    private ITreeNode m_locationPageRoot;

    public LookupCallNewWizard(IScoutBundle sharedBundle) {
        this.setWindowTitle(Texts.get((String)"NewLookupCall"));
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_sharedBundle = sharedBundle;
        IScoutBundle clientBundle = sharedBundle.getChildBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}), false);
        IScoutBundle serverBundle = sharedBundle.getChildBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}), false);
        this.m_page1 = new LookupCallNewWizardPage(this.getSharedBundle(), serverBundle);
        this.addPage((IWizardPage)this.m_page1);
        this.m_locationPageRoot = this.createTree(clientBundle, sharedBundle, serverBundle);
        this.m_page2 = new BundleTreeWizardPage(Texts.get((String)"LookupCallLocations"), Texts.get((String)"OrganiseLocations"), this.m_locationPageRoot, new P_InitialCheckedFilter());
        this.m_page2.addStatusProvider(statusProvider);
        this.m_page2.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_page2);
        this.m_page1.addPropertyChangeListener(new P_LocationPropertyListener());
    }

    private ITreeNode createTree(IScoutBundle clientBundle, IScoutBundle sharedBundle, IScoutBundle serverBundle) {
        ITreeNode rootNode = TreeUtility.createBundleTree(sharedBundle, NodeFilters.getByType("CLIENT", "SERVER", "SHARED"));
        if (clientBundle != null) {
            ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
            if (serverBundle != null) {
                ITreeNode clientRegNode = TreeUtility.createNode(clientNode, TYPE_SERVICE_REG_CLIENT, Texts.get((String)"ServiceProxyRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"));
                clientRegNode.setEnabled(false);
            }
        }
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, TYPE_LOOKUPCALL, Texts.get((String)"LookupCall"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1).setEnabled(false);
            if (serverBundle != null) {
                TreeUtility.createNode(sharedNode, TYPE_SERVICE_INTERFACE, Texts.get((String)"IService"), ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"), 2).setEnabled(false);
            }
        }
        if (serverBundle != null) {
            ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
            TreeUtility.createNode(serverNode, TYPE_SERVICE_IMPLEMENTATION, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1).setEnabled(false);
            TreeUtility.createNode(serverNode, TYPE_SERVICE_REG_SERVER, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 2).setEnabled(false);
        }
        return rootNode;
    }

    public LookupCallNewWizardPage getFormNewPage() {
        return this.m_page1;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle interfaceBundle;
        this.m_operation = new LookupCallNewOperation();
        this.m_operation.setInterfaceRegistrationBundle(this.m_page2.getLocationBundle(TYPE_SERVICE_REG_CLIENT, true, true));
        IScoutBundle lookupCallBundle = this.m_page2.getLocationBundle(TYPE_LOOKUPCALL, true, true);
        if (lookupCallBundle != null) {
            this.m_operation.setBundle(lookupCallBundle);
            this.m_operation.setLookupCallPackageName(lookupCallBundle.getPackageName(this.m_page1.getTargetPackage()));
        }
        this.m_operation.setFormatSource(false);
        this.m_operation.setImplementationRegistrationBundle(this.m_page2.getLocationBundle(TYPE_SERVICE_REG_SERVER, true, true));
        this.m_operation.setLookupCallName(this.m_page1.getTypeName());
        IScoutBundle serviceBundle = this.m_page2.getLocationBundle(TYPE_SERVICE_IMPLEMENTATION, true, true);
        if (serviceBundle != null) {
            this.m_operation.setServiceImplementationBundle(serviceBundle);
            this.m_operation.setServiceImplementationPackage(serviceBundle.getPackageName(this.m_page1.getTargetPackage()));
        }
        if ((interfaceBundle = this.m_page2.getLocationBundle(TYPE_SERVICE_INTERFACE, true, true)) != null) {
            this.m_operation.setServiceInterfaceBundle(interfaceBundle);
            this.m_operation.setServiceInterfacePackageName(interfaceBundle.getPackageName(this.m_page1.getTargetPackage()));
        }
        switch (this.m_page1.getLookupServiceStrategy()) {
            case CREATE_NEW: {
                IType superTypeProp = this.m_page1.getServiceSuperType();
                if (superTypeProp == null) break;
                this.m_operation.setServiceSuperTypeSignature(SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName()));
                break;
            }
            case USE_EXISTING: {
                this.m_operation.setLookupService(this.m_page1.getLookupServiceType());
            }
        }
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (Exception e) {
            ScoutSdkUi.logError("exception during perfoming finish of wizard.", e);
            return false;
        }
    }

    public LookupCallNewWizardPage getPage1() {
        return this.m_page1;
    }

    public IScoutBundle getSharedBundle() {
        return this.m_sharedBundle;
    }

    private class P_InitialCheckedFilter
    implements ITreeNodeFilter {
        private P_InitialCheckedFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            return true;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = LookupCallNewWizard.this.m_page1.getTypeName();
                if (!StringUtility.isNullOrEmpty((String)typeName)) {
                    ITreeNode serviceInterfaceNode;
                    String prefix = typeName.replaceAll("LookupCall$", "");
                    TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_LOOKUPCALL)).setText(String.valueOf(prefix) + "LookupCall");
                    ITreeNode serviceImplNode = TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_SERVICE_IMPLEMENTATION));
                    if (serviceImplNode != null) {
                        serviceImplNode.setText(String.valueOf(prefix) + "LookupService");
                    }
                    if ((serviceInterfaceNode = TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_SERVICE_INTERFACE))) != null) {
                        serviceInterfaceNode.setText("I" + prefix + "LookupService");
                    }
                    LookupCallNewWizard.this.m_page2.refreshTree();
                }
            } else if (evt.getPropertyName().equals("lookupServiceStrategy")) {
                LookupCallNewWizardPage.LOOKUP_SERVICE_STRATEGY strategy = LookupCallNewWizard.this.m_page1.getLookupServiceStrategy();
                switch (strategy) {
                    case CREATE_NEW: {
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_SERVICE_IMPLEMENTATION)).setVisible(true);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_SERVICE_INTERFACE)).setVisible(true);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_SERVICE_REG_CLIENT)).setVisible(true);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_SERVICE_REG_SERVER)).setVisible(true);
                        break;
                    }
                    default: {
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_SERVICE_IMPLEMENTATION)).setVisible(false);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_SERVICE_INTERFACE)).setVisible(false);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_SERVICE_REG_CLIENT)).setVisible(false);
                        TreeUtility.findNode(LookupCallNewWizard.this.m_locationPageRoot, NodeFilters.getByType(LookupCallNewWizard.TYPE_SERVICE_REG_SERVER)).setVisible(false);
                    }
                }
                LookupCallNewWizard.this.m_page2.refreshTree();
            }
            LookupCallNewWizard.this.m_page2.pingStateChanging();
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusLookupCall());
            multiStatus.add(this.getStatusService());
            multiStatus.add(this.getStatusServiceRegistrationClient());
            multiStatus.add(this.getStatusServiceRegistrationServer());
            multiStatus.add(this.getStatusTypeNames());
        }

        protected IStatus getStatusTypeNames() {
            ITreeNode serviceInterfaceNode;
            IScoutBundle serviceInterfaceBundle;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(LookupCallNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = LookupCallNewWizard.this.m_page2.getTreeNode(LookupCallNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceImplementationBundle.getPackageName(LookupCallNewWizard.this.m_page1.getTargetPackage())) + "." + serviceImplNode.getText();
                    IType findType = serviceImplementationBundle.getJavaProject().findType(fqn);
                    if (findType != null && findType.exists()) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((serviceInterfaceBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(LookupCallNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && (serviceInterfaceNode = LookupCallNewWizard.this.m_page2.getTreeNode(LookupCallNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceInterfaceBundle.getPackageName(LookupCallNewWizard.this.m_page1.getTargetPackage())) + "." + serviceInterfaceNode.getText();
                    IType interfaceType = serviceInterfaceBundle.getJavaProject().findType(fqn);
                    if (interfaceType != null && interfaceType.exists()) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusLookupCall() {
            IScoutBundle serviceInterfaceBundle;
            IScoutBundle lookupCallBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(LookupCallNewWizard.TYPE_LOOKUPCALL, true, true);
            if (lookupCallBundle != null && (serviceInterfaceBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(LookupCallNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)lookupCallBundle)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{LookupCallNewWizard.this.m_page2.getTextOfNode(LookupCallNewWizard.TYPE_SERVICE_INTERFACE), LookupCallNewWizard.this.m_page2.getTextOfNode(LookupCallNewWizard.TYPE_LOOKUPCALL)}));
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceInterfaceBundle;
            IScoutBundle serviceImplementationBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(LookupCallNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceInterfaceBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(LookupCallNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceImplementationBundle)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{LookupCallNewWizard.this.m_page2.getTextOfNode(LookupCallNewWizard.TYPE_SERVICE_INTERFACE), LookupCallNewWizard.this.m_page2.getTextOfNode(LookupCallNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationClient() {
            ITreeNode[] serviceRegistrationClientNodes;
            IScoutBundle serviceInterfaceBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(LookupCallNewWizard.TYPE_SERVICE_INTERFACE, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationClientNodes = LookupCallNewWizard.this.m_page2.getTreeNodes(LookupCallNewWizard.TYPE_SERVICE_REG_CLIENT, true, true);
            int n = serviceRegistrationClientNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle != null && serviceRegistrationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{LookupCallNewWizard.this.m_page2.getTextOfNode(LookupCallNewWizard.TYPE_SERVICE_INTERFACE), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = LookupCallNewWizard.this.m_page2.getLocationBundle(LookupCallNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = LookupCallNewWizard.this.m_page2.getTreeNodes(LookupCallNewWizard.TYPE_SERVICE_REG_SERVER, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && serviceRegistrationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceImplementationBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{LookupCallNewWizard.this.m_page2.getTextOfNode(LookupCallNewWizard.TYPE_SERVICE_IMPLEMENTATION), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            return !LookupCallNewWizard.TYPE_LOOKUPCALL.equals(node.getType());
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.targetParent.getData() instanceof IScoutBundle && ((IScoutBundle)dndEvent.targetParent.getData()).isBinary()) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            LookupCallNewWizard.this.m_page1.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = LookupCallNewWizard.TYPE_SERVICE_REG_CLIENT.equals(t) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (LookupCallNewWizard.TYPE_SERVICE_REG_SERVER.equals(t) ? "SERVER".equals(dndEvent.targetParent.getType()) : false);
        }

        private void validateDropMove(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = LookupCallNewWizard.TYPE_SERVICE_REG_CLIENT.equals(t) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (LookupCallNewWizard.TYPE_SERVICE_IMPLEMENTATION.equals(t) || LookupCallNewWizard.TYPE_SERVICE_REG_SERVER.equals(t) ? "SERVER".equals(dndEvent.targetParent.getType()) : false);
        }
    }
}

