/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.lookupcall;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.MoreElementsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.lookupcall.LookupCallNewWizard;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class LookupCallNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iLookupService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService");
    private final IType abstractLookupService = TypeUtility.getType((String)"org.eclipse.scout.rt.server.services.lookup.AbstractLookupService");
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SERVICE_SUPER_TYPE = "serviceSuperType";
    public static final String PROP_LOOKUP_SERVICE = "lookupService";
    public static final String PROP_LOOKUP_SERVICE_STRATEGY = "lookupServiceStrategy";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    private StyledTextField m_typeNameField;
    private Button m_createServiceButton;
    private Button m_useServiceButton;
    private Button m_noServiceButton;
    private ProposalTextField m_serviceSuperTypeField;
    private ProposalTextField m_lookupServiceTypeField;
    private EntityTextField m_entityField;
    private IType m_abstractSqlLookupService;
    private final IScoutBundle m_sharedBundle;
    private final IScoutBundle m_serverBundle;

    public LookupCallNewWizardPage(IScoutBundle sharedBundle, IScoutBundle serverBundle) {
        super(LookupCallNewWizardPage.class.getName());
        this.m_sharedBundle = sharedBundle;
        this.m_serverBundle = serverBundle;
        this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)sharedBundle, (String)"shared.services.lookup"));
        this.setTitle(Texts.get((String)"NewLookupCall"));
        this.setDescription(Texts.get((String)"CreateANewLookupCall"));
        if (serverBundle != null) {
            this.setLookupServiceStrategy(LOOKUP_SERVICE_STRATEGY.CREATE_NEW);
            this.m_abstractSqlLookupService = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService", (IJavaProject)serverBundle.getJavaProject());
            this.setServiceSuperTypeInternal(this.m_abstractSqlLookupService);
        } else {
            this.setLookupServiceStrategy(LOOKUP_SERVICE_STRATEGY.NO_SERVICE);
        }
    }

    @Override
    protected void createContent(Composite parent) {
        int labelPercentage = 20;
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"), labelPercentage);
        this.m_typeNameField.setReadOnlySuffix("LookupCall");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LookupCallNewWizardPage.this.setTypeNameInternal(LookupCallNewWizardPage.this.m_typeNameField.getText());
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField(parent, Texts.get((String)"EntityTextField"), this.m_sharedBundle, labelPercentage);
            this.m_entityField.setText(this.getTargetPackage());
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LookupCallNewWizardPage.this.setTargetPackageInternal(LookupCallNewWizardPage.this.m_entityField.getText());
                    LookupCallNewWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
        }
        Control lookupServiceGroup = this.createLookupServiceGroup(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        lookupServiceGroup.setLayoutData((Object)new GridData(768));
    }

    protected Control createLookupServiceGroup(Composite parent) {
        AbstractJavaElementContentProvider contentProvider;
        Group group = new Group(parent, 16);
        group.setText("Lookup Service");
        boolean serverAvailable = this.getServerBundle() != null;
        Composite radioButtons = new Composite((Composite)group, 1);
        this.m_createServiceButton = new Button(radioButtons, 16);
        this.m_createServiceButton.addSelectionListener((SelectionListener)new P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY.CREATE_NEW));
        this.m_createServiceButton.setText("create new lookup service");
        this.m_createServiceButton.setSelection(serverAvailable);
        this.m_useServiceButton = new Button(radioButtons, 16);
        this.m_useServiceButton.addSelectionListener((SelectionListener)new P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY.USE_EXISTING));
        this.m_useServiceButton.setText("use existing lookup service");
        this.m_noServiceButton = new Button(radioButtons, 16);
        this.m_noServiceButton.addSelectionListener((SelectionListener)new P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY.NO_SERVICE));
        this.m_noServiceButton.setText("no lookup service");
        this.m_noServiceButton.setSelection(!serverAvailable);
        this.m_serviceSuperTypeField = this.getFieldToolkit().createProposalField((Composite)group, Texts.get((String)"LookupServiceSuperType"));
        if (serverAvailable) {
            contentProvider = new AbstractJavaElementContentProvider(){

                @Override
                protected Object[][] computeProposals() {
                    IType[] abstractLookupServices;
                    ArrayList<Object> proposals = new ArrayList<Object>();
                    proposals.add(LookupCallNewWizardPage.this.abstractLookupService);
                    if (LookupCallNewWizardPage.this.m_abstractSqlLookupService != null) {
                        proposals.add(LookupCallNewWizardPage.this.m_abstractSqlLookupService);
                    }
                    proposals.add(MoreElementsProposal.INSTANCE);
                    IPrimaryTypeTypeHierarchy lookupServiceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)LookupCallNewWizardPage.this.iLookupService);
                    IType[] iTypeArray = abstractLookupServices = lookupServiceHierarchy.getAllClasses(TypeFilters.getAbstractOnClasspath((IJavaProject)LookupCallNewWizardPage.this.getServerBundle().getJavaProject()), TypeComparators.getTypeNameComparator());
                    int n = abstractLookupServices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType t = iTypeArray[n2];
                        if (!proposals.contains(t)) {
                            proposals.add(t);
                        }
                        ++n2;
                    }
                    return new Object[][]{proposals.toArray(new Object[proposals.size()])};
                }
            };
            this.m_serviceSuperTypeField.setContentProvider(contentProvider);
            this.m_serviceSuperTypeField.setLabelProvider((IBaseLabelProvider)contentProvider.getLabelProvider());
            this.m_serviceSuperTypeField.acceptProposal(this.getServiceSuperType());
        } else {
            this.m_serviceSuperTypeField.setEnabled(false);
            radioButtons.setEnabled(false);
        }
        this.m_serviceSuperTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                LookupCallNewWizardPage.this.setServiceSuperTypeInternal((IType)event.proposal);
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_lookupServiceTypeField = this.getFieldToolkit().createProposalField((Composite)group, Texts.get((String)"LookupService"));
        if (this.getSharedBundle() != null) {
            contentProvider = new AbstractJavaElementContentProvider(){

                @Override
                protected Object[][] computeProposals() {
                    IPrimaryTypeTypeHierarchy lookupServiceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)LookupCallNewWizardPage.this.iLookupService);
                    IType[] lookupServices = lookupServiceHierarchy.getAllInterfaces(TypeFilters.getTypesOnClasspath((IJavaProject)LookupCallNewWizardPage.this.getSharedBundle().getJavaProject()), TypeComparators.getTypeNameComparator());
                    return new Object[][]{lookupServices};
                }
            };
            this.m_lookupServiceTypeField.setContentProvider(contentProvider);
            this.m_lookupServiceTypeField.setLabelProvider((IBaseLabelProvider)contentProvider.getLabelProvider());
        } else {
            this.m_lookupServiceTypeField.setEnabled(false);
        }
        this.m_lookupServiceTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                LookupCallNewWizardPage.this.setLookupServiceTypeInternal((IType)event.proposal);
                LookupCallNewWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        radioButtons.setLayoutData((Object)new GridData(768));
        GridLayout radioButtonGroupLayout = new GridLayout(3, true);
        radioButtons.setLayout((Layout)radioButtonGroupLayout);
        this.m_createServiceButton.setLayoutData((Object)new GridData(768));
        this.m_useServiceButton.setLayoutData((Object)new GridData(768));
        this.m_noServiceButton.setLayoutData((Object)new GridData(768));
        this.m_serviceSuperTypeField.setLayoutData(new GridData(768));
        GridData lookupServiceData = new GridData(768);
        lookupServiceData.exclude = true;
        this.m_lookupServiceTypeField.setLayoutData(lookupServiceData);
        return group;
    }

    public LookupCallNewWizard getWizard() {
        return (LookupCallNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusLookupService());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("LookupCall")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_className"));
        }
        if (TypeUtility.existsType((String)(String.valueOf(this.getSharedBundle().getPackageName(this.getTargetPackage())) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getLookupServiceStrategy() == LOOKUP_SERVICE_STRATEGY.CREATE_NEW && this.getServiceSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusLookupService() throws JavaModelException {
        if (this.getLookupServiceStrategy() == LOOKUP_SERVICE_STRATEGY.USE_EXISTING && this.getLookupServiceType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheLookupCallCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getSharedBundle() {
        return this.m_sharedBundle;
    }

    public IScoutBundle getServerBundle() {
        return this.m_serverBundle;
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public LOOKUP_SERVICE_STRATEGY getLookupServiceStrategy() {
        Object strategy = this.getProperty(PROP_LOOKUP_SERVICE_STRATEGY);
        if (!(strategy instanceof LOOKUP_SERVICE_STRATEGY)) {
            strategy = LOOKUP_SERVICE_STRATEGY.NO_SERVICE;
        }
        return (LOOKUP_SERVICE_STRATEGY)((Object)strategy);
    }

    public void setLookupServiceStrategy(LOOKUP_SERVICE_STRATEGY strategy) {
        try {
            if (strategy == null) {
                strategy = LOOKUP_SERVICE_STRATEGY.NO_SERVICE;
            }
            this.setStateChanging(true);
            this.setLookupServiceStrategyInternal(strategy);
            if (this.isControlCreated()) {
                switch (strategy) {
                    case CREATE_NEW: {
                        this.m_createServiceButton.setSelection(true);
                        break;
                    }
                    case USE_EXISTING: {
                        this.m_useServiceButton.setSelection(true);
                        break;
                    }
                    case NO_SERVICE: {
                        this.m_noServiceButton.setSelection(true);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLookupServiceStrategyInternal(LOOKUP_SERVICE_STRATEGY strategy) {
        this.setProperty(PROP_LOOKUP_SERVICE_STRATEGY, (Object)strategy);
    }

    public IType getServiceSuperType() {
        return (IType)this.getProperty(PROP_SERVICE_SUPER_TYPE);
    }

    public void setServiceSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setServiceSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_serviceSuperTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setServiceSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SERVICE_SUPER_TYPE, superType);
    }

    public IType getLookupServiceType() {
        return (IType)this.getProperty(PROP_LOOKUP_SERVICE);
    }

    public void setLookupServiceType(IType lookupService) {
        try {
            this.setStateChanging(true);
            this.setLookupServiceTypeInternal(lookupService);
            if (this.isControlCreated()) {
                this.m_lookupServiceTypeField.acceptProposal(lookupService);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setLookupServiceTypeInternal(IType lookupService) {
        this.setProperty(PROP_LOOKUP_SERVICE, lookupService);
    }

    public String getTargetPackage() {
        return (String)this.getProperty(PROP_TARGET_PACKAGE);
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.setProperty(PROP_TARGET_PACKAGE, targetPackage);
    }

    public static enum LOOKUP_SERVICE_STRATEGY {
        CREATE_NEW,
        USE_EXISTING,
        NO_SERVICE;

    }

    private class P_LookupServiceStrategyButtonListener
    extends SelectionAdapter {
        private final LOOKUP_SERVICE_STRATEGY m_strategy;

        public P_LookupServiceStrategyButtonListener(LOOKUP_SERVICE_STRATEGY strategy) {
            this.m_strategy = strategy;
        }

        public void widgetSelected(SelectionEvent e) {
            LookupCallNewWizardPage.this.setLookupServiceStrategyInternal(this.m_strategy);
            switch (this.m_strategy) {
                case CREATE_NEW: {
                    LookupCallNewWizardPage.this.m_serviceSuperTypeField.setVisible(true);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_serviceSuperTypeField.getLayoutData()).exclude = false;
                    LookupCallNewWizardPage.this.m_lookupServiceTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_lookupServiceTypeField.getLayoutData()).exclude = true;
                    break;
                }
                case USE_EXISTING: {
                    LookupCallNewWizardPage.this.m_serviceSuperTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_serviceSuperTypeField.getLayoutData()).exclude = true;
                    LookupCallNewWizardPage.this.m_lookupServiceTypeField.setVisible(true);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_lookupServiceTypeField.getLayoutData()).exclude = false;
                    break;
                }
                case NO_SERVICE: {
                    LookupCallNewWizardPage.this.m_serviceSuperTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_serviceSuperTypeField.getLayoutData()).exclude = true;
                    LookupCallNewWizardPage.this.m_lookupServiceTypeField.setVisible(false);
                    ((GridData)((LookupCallNewWizardPage)LookupCallNewWizardPage.this).m_lookupServiceTypeField.getLayoutData()).exclude = true;
                }
            }
            LookupCallNewWizardPage.this.m_lookupServiceTypeField.getParent().layout(true);
            LookupCallNewWizardPage.this.pingStateChanging();
        }
    }
}

