/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.page;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.page.PageNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.validation.JavaElementValidator;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PageNewAttributesWizardPage
extends AbstractWorkspaceWizardPage {
    private IType iPage = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage");
    private IType iPageWithNodes = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes");
    private IType iPageWithTable = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable");
    private IType iOutline = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private IType m_holderType;
    private String m_nameSuffix;
    private String m_packageName;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_holderTypeField;
    private EntityTextField m_entityField;
    private PageNewOperation m_operation;
    private boolean m_hoderTypeEnabled = true;
    private final IScoutBundle m_clientBundle;

    public PageNewAttributesWizardPage(IScoutBundle clientBundle) {
        super(PageNewAttributesWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.setTitle(Texts.get((String)"NewPage"));
        this.setDescription(Texts.get((String)"CreateANewPage"));
        this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)clientBundle, (String)"client.page"));
        this.m_nameSuffix = "";
        this.setSuperType(RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes", (IJavaProject)this.m_clientBundle.getJavaProject()));
        this.setOperation(new PageNewOperation(true));
    }

    @Override
    protected void createContent(Composite parent) {
        int labelColWidthPercent = 20;
        Group group = new Group(parent, 64);
        group.setText(Texts.get((String)"Page"));
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField((Composite)group, this.getClientBundle().getNlsProject(), Texts.get((String)"Name"), labelColWidthPercent);
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    PageNewAttributesWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = PageNewAttributesWizardPage.this.getNlsName();
                    PageNewAttributesWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (PageNewAttributesWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(PageNewAttributesWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)PageNewAttributesWizardPage.this.m_typeNameField.getModifiableText()))) {
                        PageNewAttributesWizardPage.this.m_typeNameField.setText(PageNewAttributesWizardPage.this.m_nlsName.getKey());
                    }
                }
                finally {
                    PageNewAttributesWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField((Composite)group, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix(this.m_nameSuffix);
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageNewAttributesWizardPage.this.m_typeName = PageNewAttributesWizardPage.this.m_typeNameField.getText();
                PageNewAttributesWizardPage.this.pingStateChanging();
            }
        });
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField((Composite)group, Texts.get((String)"EntityTextField"), this.m_clientBundle, labelColWidthPercent);
            this.m_entityField.setText(this.getTargetPackage());
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PageNewAttributesWizardPage.this.setTargetPackageInternal(PageNewAttributesWizardPage.this.m_entityField.getText());
                    PageNewAttributesWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
        }
        Control parentPageControl = this.createParentPageGroup(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        parentPageControl.setLayoutData((Object)new GridData(768));
    }

    protected Control createParentPageGroup(Composite parent) {
        Group group = new Group(parent, 64);
        group.setText(Texts.get((String)"AddTo"));
        this.m_holderTypeField = this.getFieldToolkit().createJavaElementProposalField((Composite)group, Texts.get((String)"PageOutline"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{ScoutTypeFilters.getInScoutBundles((IScoutBundle[])new IScoutBundle[]{PageNewAttributesWizardPage.this.getClientBundle()}), TypeFilters.getClassFilter()});
                IType[] pages = TypeUtility.getPrimaryTypeHierarchy((IType)PageNewAttributesWizardPage.this.iPage).getAllSubtypes(PageNewAttributesWizardPage.this.iPageWithNodes, filter);
                IType[] outlines = TypeUtility.getPrimaryTypeHierarchy((IType)PageNewAttributesWizardPage.this.iOutline).getAllSubtypes(PageNewAttributesWizardPage.this.iOutline, filter);
                IType[] propTypes = new IType[pages.length + outlines.length];
                System.arraycopy(pages, 0, propTypes, 0, pages.length);
                System.arraycopy(outlines, 0, propTypes, pages.length, outlines.length);
                Arrays.sort(propTypes, TypeComparators.getTypeNameComparator());
                return new Object[][]{propTypes};
            }
        });
        this.m_holderTypeField.acceptProposal(this.getHolderType());
        this.m_holderTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                PageNewAttributesWizardPage.this.m_holderType = (IType)event.proposal;
                PageNewAttributesWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_holderTypeField.setLayoutData(new GridData(768));
        return group;
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        this.getOperation().setClientBundle(this.getClientBundle());
        this.getOperation().setNlsEntry(this.getNlsName());
        this.getOperation().setTypeName(this.getTypeName());
        this.getOperation().setPackageName(this.getClientBundle().getPackageName(this.getTargetPackage()));
        IType superType = this.getSuperType();
        if (superType != null) {
            this.getOperation().setSuperTypeSignature(SignatureCache.createTypeSignature((String)superType.getFullyQualifiedName()));
        }
        this.getOperation().setHolderType(this.getHolderType());
        this.getOperation().run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusClientBundle());
            if (!multiStatus.matches(4)) {
                multiStatus.add(this.getStatusNameField());
                multiStatus.add(this.getStatusTargetPackge());
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusTargetPackge() {
        return JavaElementValidator.validatePackageName((String)this.getTargetPackage());
    }

    protected IStatus getStatusClientBundle() throws JavaModelException {
        if (this.getClientBundle() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ClientBundleMissing"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals(this.m_nameSuffix)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_className"));
        }
        if (TypeUtility.existsType((String)(String.valueOf(this.getClientBundle().getPackageName(this.getTargetPackage())) + "." + this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    public void setOperation(PageNewOperation operation) {
        this.m_operation = operation;
    }

    public PageNewOperation getOperation() {
        return this.m_operation;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (TypeUtility.exists((IJavaElement)superType)) {
                try {
                    ITypeHierarchy superTypeHierarchy = superType.newSupertypeHierarchy(null);
                    this.m_nameSuffix = superTypeHierarchy.contains(this.iPageWithNodes) ? "NodePage" : (superTypeHierarchy.contains(this.iPageWithTable) ? "TablePage" : "Page");
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError("could not create superTypeHierarchy of '" + this.getSuperType().getFullyQualifiedName() + "'.");
                }
            }
            if (this.isControlCreated()) {
                this.m_typeNameField.setReadOnlySuffix(this.m_nameSuffix);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setHolderType(IType holderPage) {
        try {
            this.setStateChanging(true);
            this.m_holderType = holderPage;
            if (this.isControlCreated()) {
                this.m_holderTypeField.acceptProposal(holderPage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getHolderType() {
        return this.m_holderType;
    }

    public void setHoderTypeEnabled(boolean hoderTypeEnabled) {
        if (this.isControlCreated()) {
            throw new IllegalStateException("control already created.");
        }
        this.m_hoderTypeEnabled = hoderTypeEnabled;
    }

    public boolean isHoderTypeEnabled() {
        return this.m_hoderTypeEnabled;
    }

    public String getTargetPackage() {
        return this.m_packageName;
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.m_packageName = targetPackage;
    }
}

