/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.method.MethodOverrideOperation;
import org.eclipse.scout.sdk.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.services.ServiceNewWizardPage;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class BookmarkStorageServiceNewWizard
extends AbstractWorkspaceWizard {
    public static final String TYPE_SERVICE_INTERFACE = "svcIfc";
    public static final String TYPE_SERVICE_IMPLEMENTATION = "svcImpl";
    public static final String TYPE_SERVICE_REG_CLIENT = "svcRegClient";
    public static final String TYPE_SERVICE_REG_SERVER = "svcRegServer";
    private ServiceNewWizardPage m_serviceNewWizardPage;
    private BundleTreeWizardPage m_locationWizardPage;
    private ITreeNode m_locationWizardPageRoot;
    private ServiceNewOperation m_operation = new ServiceNewOperation();

    public BookmarkStorageServiceNewWizard(IScoutBundle serverBundle) {
        this.setWindowTitle(Texts.get((String)"NewBookmarkService"));
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_serviceNewWizardPage = new ServiceNewWizardPage(Texts.get((String)"NewBookmarkStorageService"), Texts.get((String)"CreateANewBookmarkStorageService"), TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService"), "BookmarkStorageService", serverBundle, DefaultTargetPackage.get((IScoutBundle)serverBundle, (String)"server.services.bookmark"));
        this.m_serviceNewWizardPage.setLocationBundle(serverBundle);
        this.m_serviceNewWizardPage.setSuperType(TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService"));
        this.m_serviceNewWizardPage.addStatusProvider(statusProvider);
        this.m_serviceNewWizardPage.addPropertyChangeListener(new P_LocationPropertyListener());
        this.addPage((IWizardPage)this.m_serviceNewWizardPage);
        this.m_locationWizardPageRoot = this.createTree(serverBundle);
        this.m_locationWizardPage = new BundleTreeWizardPage(Texts.get((String)"BookmarkStorageServiceLocation"), Texts.get((String)"OrganiseLocations"), this.m_locationWizardPageRoot, new P_InitialCheckerFilter());
        this.m_locationWizardPage.addStatusProvider(statusProvider);
        this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_locationWizardPage);
        this.m_serviceNewWizardPage.setSuperType(RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService", (IJavaProject)serverBundle.getJavaProject()));
    }

    private ITreeNode createTree(IScoutBundle serverBundle) {
        IScoutBundle sharedBundle = null;
        IScoutBundle clientBundle = null;
        if (serverBundle != null && (sharedBundle = serverBundle.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false)) != null) {
            clientBundle = sharedBundle.getChildBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}), serverBundle, false);
        }
        ITreeNode rootNode = TreeUtility.createBundleTree(serverBundle, NodeFilters.getByType("CLIENT", "SERVER", "SHARED"));
        if (clientBundle != null) {
            ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
            TreeUtility.createNode(clientNode, TYPE_SERVICE_REG_CLIENT, Texts.get((String)"ServiceProxyRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"));
        }
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, TYPE_SERVICE_INTERFACE, Texts.get((String)"IService"), ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"));
        }
        if (serverBundle != null) {
            ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
            TreeUtility.createNode(serverNode, TYPE_SERVICE_IMPLEMENTATION, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
            TreeUtility.createNode(serverNode, TYPE_SERVICE_REG_SERVER, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 2);
        }
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle[] serverRegBundles;
        IScoutBundle[] regProxyLocations;
        IScoutBundle implementationBundle;
        IType superType = this.m_serviceNewWizardPage.getSuperType();
        if (superType != null) {
            this.m_operation.setServiceSuperTypeSignature(SignatureCache.createTypeSignature((String)superType.getFullyQualifiedName()));
        }
        if ((implementationBundle = this.m_locationWizardPage.getLocationBundle(TYPE_SERVICE_IMPLEMENTATION, true, true)) != null) {
            this.m_operation.setImplementationBundle(implementationBundle);
            this.m_operation.setServicePackageName(implementationBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage()));
            this.m_operation.setServiceName(this.m_locationWizardPage.getTextOfNode(TYPE_SERVICE_IMPLEMENTATION, true, true));
        }
        this.m_operation.setServiceInterfaceSuperTypeSignature(SignatureCache.createTypeSignature((String)"org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService"));
        IScoutBundle[] iScoutBundleArray = regProxyLocations = this.m_locationWizardPage.getLocationBundles(TYPE_SERVICE_REG_CLIENT, true, true);
        int n = regProxyLocations.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle cb = iScoutBundleArray[n2];
            this.m_operation.addProxyRegistrationBundle(cb);
            ++n2;
        }
        IScoutBundle[] iScoutBundleArray2 = serverRegBundles = this.m_locationWizardPage.getLocationBundles(TYPE_SERVICE_REG_SERVER, true, true);
        int n3 = serverRegBundles.length;
        n = 0;
        while (n < n3) {
            IScoutBundle sb = iScoutBundleArray2[n];
            this.m_operation.addServiceRegistrationBundle(sb);
            ++n;
        }
        IScoutBundle interfaceBundle = this.m_locationWizardPage.getLocationBundle(TYPE_SERVICE_INTERFACE, true, true);
        if (interfaceBundle != null) {
            this.m_operation.setInterfaceBundle(interfaceBundle);
            this.m_operation.setServiceInterfacePackageName(interfaceBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage()));
        }
        this.m_operation.setServiceInterfaceName(this.m_locationWizardPage.getTextOfNode(TYPE_SERVICE_INTERFACE, true, true));
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.validate();
            this.m_operation.run(monitor, workingCopyManager);
            IType iServerSession = TypeUtility.getType((String)"org.eclipse.scout.rt.server.IServerSession");
            IPrimaryTypeTypeHierarchy serverSessionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iServerSession);
            IType[] serverSessions = serverSessionHierarchy.getAllSubtypes(iServerSession, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{this.m_operation.getImplementationBundle()}), TypeComparators.getTypeNameComparator());
            if (serverSessions != null && serverSessions.length == 1) {
                final IType serverSessionType = serverSessions[0];
                MethodOverrideOperation methodOp = new MethodOverrideOperation(this.m_operation.getCreatedServiceImplementation(), "getCurrentUserId", true){

                    protected String createMethodBody(IImportValidator validator) throws JavaModelException {
                        validator.addImport(serverSessionType.getFullyQualifiedName());
                        String serverSess = validator.getTypeName(SignatureCache.createTypeSignature((String)serverSessionType.getFullyQualifiedName()));
                        return "return " + serverSess + ".get().getUserId();";
                    }
                };
                methodOp.validate();
                methodOp.run(monitor, workingCopyManager);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            ScoutSdkUi.logWarning("validation error of operation '" + this.m_operation.getOperationName() + "'. " + e.getMessage());
            return false;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during executing operation '" + this.m_operation.getOperationName() + "'.", e);
            return false;
        }
    }

    private class P_InitialCheckerFilter
    implements ITreeNodeFilter {
        private P_InitialCheckerFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), BookmarkStorageServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, BookmarkStorageServiceNewWizard.TYPE_SERVICE_INTERFACE, BookmarkStorageServiceNewWizard.TYPE_SERVICE_REG_CLIENT, BookmarkStorageServiceNewWizard.TYPE_SERVICE_REG_SERVER);
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String typeName;
            if (evt.getPropertyName().equals("typeName") && !StringUtility.isNullOrEmpty((String)(typeName = BookmarkStorageServiceNewWizard.this.m_serviceNewWizardPage.getTypeName()))) {
                String prefix = typeName.replaceAll("BookmarkStorageService$", "");
                TreeUtility.findNode(BookmarkStorageServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(BookmarkStorageServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)).setText(String.valueOf(prefix) + "BookmarkStorageService");
                TreeUtility.findNode(BookmarkStorageServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(BookmarkStorageServiceNewWizard.TYPE_SERVICE_INTERFACE)).setText("I" + prefix + "BookmarkStorageService");
                BookmarkStorageServiceNewWizard.this.m_locationWizardPage.refreshTree();
            }
            BookmarkStorageServiceNewWizard.this.m_locationWizardPage.pingStateChanging();
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusService());
            multiStatus.add(this.getStatusServiceRegistrationClient());
            multiStatus.add(this.getStatusServiceRegistrationServer());
            multiStatus.add(this.getStatusTypeNames());
        }

        protected IStatus getStatusTypeNames() {
            ITreeNode serviceInterfaceNode;
            IScoutBundle serviceInterfaceBundle;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getLocationBundle(BookmarkStorageServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getTreeNode(BookmarkStorageServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceImplementationBundle.getPackageName(BookmarkStorageServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage())) + "." + serviceImplNode.getText();
                    if (serviceImplementationBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((serviceInterfaceBundle = BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getLocationBundle(BookmarkStorageServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && (serviceInterfaceNode = BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getTreeNode(BookmarkStorageServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceInterfaceBundle.getPackageName(BookmarkStorageServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage())) + "." + serviceInterfaceNode.getText();
                    if (serviceInterfaceBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceInterfaceBundle;
            IScoutBundle serviceImplementationBundle = BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getLocationBundle(BookmarkStorageServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceInterfaceBundle = BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getLocationBundle(BookmarkStorageServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceImplementationBundle)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getTextOfNode(BookmarkStorageServiceNewWizard.TYPE_SERVICE_INTERFACE), BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getTextOfNode(BookmarkStorageServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationClient() {
            ITreeNode[] serviceRegistrationClientNodes;
            IScoutBundle serviceInterfaceBundle = BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getLocationBundle(BookmarkStorageServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationClientNodes = BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getTreeNodes(BookmarkStorageServiceNewWizard.TYPE_SERVICE_REG_CLIENT, true, true);
            int n = serviceRegistrationClientNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle != null && serviceRegistrationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getTextOfNode(BookmarkStorageServiceNewWizard.TYPE_SERVICE_INTERFACE), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getLocationBundle(BookmarkStorageServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getTreeNodes(BookmarkStorageServiceNewWizard.TYPE_SERVICE_REG_SERVER, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && serviceRegistrationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceImplementationBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{BookmarkStorageServiceNewWizard.this.m_locationWizardPage.getTextOfNode(BookmarkStorageServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), BookmarkStorageServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, BookmarkStorageServiceNewWizard.TYPE_SERVICE_INTERFACE, BookmarkStorageServiceNewWizard.TYPE_SERVICE_REG_CLIENT, BookmarkStorageServiceNewWizard.TYPE_SERVICE_REG_SERVER);
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.targetParent.getData() instanceof IScoutBundle && ((IScoutBundle)dndEvent.targetParent.getData()).isBinary()) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            BookmarkStorageServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = BookmarkStorageServiceNewWizard.TYPE_SERVICE_REG_CLIENT.equals(t) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (BookmarkStorageServiceNewWizard.TYPE_SERVICE_REG_SERVER.equals(t) ? "SERVER".equals(dndEvent.targetParent.getType()) : false);
        }

        private void validateDropMove(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = BookmarkStorageServiceNewWizard.TYPE_SERVICE_REG_CLIENT.equals(t) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (BookmarkStorageServiceNewWizard.TYPE_SERVICE_INTERFACE.equals(t) ? "SHARED".equals(dndEvent.targetParent.getType()) : (BookmarkStorageServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION.equals(t) || BookmarkStorageServiceNewWizard.TYPE_SERVICE_REG_SERVER.equals(t) ? "SERVER".equals(dndEvent.targetParent.getType()) : false));
        }
    }
}

