/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.services.ServiceNewWizardPage;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class ClientServiceNewWizard
extends AbstractWorkspaceWizard {
    public static final String TYPE_SERVICE_INTERFACE = "svcIfc";
    public static final String TYPE_SERVICE_IMPLEMENTATION = "svcImpl";
    public static final String TYPE_SERVICE_REGISTRATION = "svcReg";
    private BundleTreeWizardPage m_locationWizardPage;
    private ServiceNewWizardPage m_serviceNewWizardPage;
    private ServiceNewOperation m_operation = new ServiceNewOperation();
    private ITreeNode m_locationPageRoot;

    public ClientServiceNewWizard(IScoutBundle clientBundle) {
        this.setWindowTitle(Texts.get((String)"NewClientService"));
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_serviceNewWizardPage = new ServiceNewWizardPage(Texts.get((String)"NewClientService"), Texts.get((String)"CreateANewClientService"), TypeUtility.getType((String)"org.eclipse.scout.service.IService"), "Service", clientBundle, DefaultTargetPackage.get((IScoutBundle)clientBundle, (String)"client.services"));
        this.m_serviceNewWizardPage.setLocationBundle(clientBundle);
        this.m_serviceNewWizardPage.addStatusProvider(statusProvider);
        this.m_serviceNewWizardPage.addPropertyChangeListener(new P_LocationPropertyListener());
        this.addPage((IWizardPage)this.m_serviceNewWizardPage);
        this.m_locationPageRoot = this.createTree(clientBundle);
        this.m_locationWizardPage = new BundleTreeWizardPage(Texts.get((String)"ServiceLocation"), Texts.get((String)"OrganiseLocations"), this.m_locationPageRoot, NodeFilters.getByData(null));
        this.m_locationWizardPage.addStatusProvider(statusProvider);
        this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
        this.addPage((IWizardPage)this.m_locationWizardPage);
        this.m_serviceNewWizardPage.setSuperType(RuntimeClasses.getSuperType((String)"org.eclipse.scout.service.IService", (IJavaProject)clientBundle.getJavaProject()));
    }

    private ITreeNode createTree(IScoutBundle clientBundle) {
        ITreeNode rootNode = TreeUtility.createBundleTree(clientBundle, NodeFilters.getByType("CLIENT", "SHARED"));
        ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
        TreeUtility.createNode(clientNode, TYPE_SERVICE_IMPLEMENTATION, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
        TreeUtility.createNode(clientNode, TYPE_SERVICE_INTERFACE, Texts.get((String)"IService"), ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"), 2);
        TreeUtility.createNode(clientNode, TYPE_SERVICE_REGISTRATION, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 3);
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle interfaceBundle;
        IScoutBundle implementationBundle = this.m_locationWizardPage.getLocationBundle(TYPE_SERVICE_IMPLEMENTATION, true, true);
        if (implementationBundle != null) {
            this.m_operation.setImplementationBundle(implementationBundle);
            this.m_operation.setServicePackageName(implementationBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage()));
        }
        if ((interfaceBundle = this.m_locationWizardPage.getLocationBundle(TYPE_SERVICE_INTERFACE, true, true)) != null) {
            this.m_operation.setInterfaceBundle(interfaceBundle);
            this.m_operation.setServiceInterfacePackageName(interfaceBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage()));
        }
        this.m_operation.setServiceInterfaceName(this.m_locationWizardPage.getTextOfNode(TYPE_SERVICE_INTERFACE, true, true));
        this.m_operation.setServiceInterfaceSuperTypeSignature(SignatureCache.createTypeSignature((String)"org.eclipse.scout.service.IService"));
        IType superType = this.m_serviceNewWizardPage.getSuperType();
        if (superType != null) {
            this.m_operation.setServiceSuperTypeSignature(SignatureCache.createTypeSignature((String)superType.getFullyQualifiedName()));
        }
        this.m_operation.setServiceName(this.m_locationWizardPage.getTextOfNode(TYPE_SERVICE_IMPLEMENTATION, true, true));
        IScoutBundle[] iScoutBundleArray = this.m_locationWizardPage.getLocationBundles(TYPE_SERVICE_REGISTRATION, true, true);
        int n = iScoutBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle sb = iScoutBundleArray[n2];
            this.m_operation.addServiceRegistrationBundle(sb);
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.validate();
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (IllegalArgumentException e) {
            ScoutSdkUi.logWarning("validation error of operation '" + this.m_operation.getOperationName() + "'. " + e.getMessage());
            return false;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during executing operation '" + this.m_operation.getOperationName() + "'.", e);
            return false;
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String typeName;
            if (evt.getPropertyName().equals("typeName") && !StringUtility.isNullOrEmpty((String)(typeName = ClientServiceNewWizard.this.m_serviceNewWizardPage.getTypeName()))) {
                String prefix = typeName.replaceAll("Service$", "");
                TreeUtility.findNode(ClientServiceNewWizard.this.m_locationPageRoot, NodeFilters.getByType(ClientServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)).setText(String.valueOf(prefix) + "Service");
                TreeUtility.findNode(ClientServiceNewWizard.this.m_locationPageRoot, NodeFilters.getByType(ClientServiceNewWizard.TYPE_SERVICE_INTERFACE)).setText("I" + prefix + "Service");
                ClientServiceNewWizard.this.m_locationWizardPage.refreshTree();
            }
            ClientServiceNewWizard.this.m_locationWizardPage.pingStateChanging();
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusTypeNames());
            multiStatus.add(this.getStatusServiceRegistration());
            multiStatus.add(this.getStatusService());
        }

        protected IStatus getStatusTypeNames() {
            ITreeNode serviceInterfaceNode;
            IScoutBundle serviceInterfaceBundle;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = ClientServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ClientServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = ClientServiceNewWizard.this.m_locationWizardPage.getTreeNode(ClientServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceImplementationBundle.getPackageName(ClientServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage())) + "." + serviceImplNode.getText();
                    if (serviceImplementationBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((serviceInterfaceBundle = ClientServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ClientServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && (serviceInterfaceNode = ClientServiceNewWizard.this.m_locationWizardPage.getTreeNode(ClientServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceInterfaceBundle.getPackageName(ClientServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage())) + "." + serviceInterfaceNode.getText();
                    if (serviceInterfaceBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceInterfaceBundle;
            IScoutBundle serviceImplementationBundle = ClientServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ClientServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceInterfaceBundle = ClientServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ClientServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceImplementationBundle)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{ClientServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ClientServiceNewWizard.TYPE_SERVICE_INTERFACE), ClientServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ClientServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)}));
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistration() {
            ITreeNode[] registrationNodes;
            IScoutBundle serviceInterfaceBundle = ClientServiceNewWizard.this.m_locationWizardPage.getLocationBundle(ClientServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true);
            ITreeNode[] iTreeNodeArray = registrationNodes = ClientServiceNewWizard.this.m_locationWizardPage.getTreeNodes(ClientServiceNewWizard.TYPE_SERVICE_REGISTRATION, true, true);
            int n = registrationNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle != null && serviceRegistrationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{ClientServiceNewWizard.this.m_locationWizardPage.getTextOfNode(ClientServiceNewWizard.TYPE_SERVICE_INTERFACE), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), ClientServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, ClientServiceNewWizard.TYPE_SERVICE_INTERFACE, ClientServiceNewWizard.TYPE_SERVICE_REGISTRATION);
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.targetParent.getData() instanceof IScoutBundle && ((IScoutBundle)dndEvent.targetParent.getData()).isBinary()) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        private void validateDropCopy(DndEvent dndEvent) {
            dndEvent.doit = ClientServiceNewWizard.TYPE_SERVICE_REGISTRATION.equals(dndEvent.node.getType()) ? "CLIENT".equals(dndEvent.targetParent.getType()) : false;
        }

        private void validateDropMove(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = TreeUtility.isOneOf(t, ClientServiceNewWizard.TYPE_SERVICE_REGISTRATION, ClientServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, ClientServiceNewWizard.TYPE_SERVICE_INTERFACE) ? "CLIENT".equals(dndEvent.targetParent.getType()) : false;
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            ClientServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
        }
    }
}

