/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.service.ParameterArgument;
import org.eclipse.scout.sdk.operation.service.ServiceOperationNewOperation;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.scout.sdk.ui.internal.fields.code.IParameterFieldListener;
import org.eclipse.scout.sdk.ui.internal.fields.code.ParameterField;
import org.eclipse.scout.sdk.ui.internal.fields.code.ReturnParameterField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ServiceOperationNewWizardPage
extends AbstractWorkspaceWizardPage {
    private TextField m_operationNameField;
    private ReturnParameterField m_returnParameterField;
    private String m_operationName;
    private ParameterArgument m_returnParameter;
    private ParameterArgument m_parameterArg1;
    private ParameterArgument m_parameterArg2;
    private ParameterArgument m_parameterArg3;
    private ParameterArgument m_parameterArg4;
    private ParameterArgument m_parameterArg5;
    private final IType[] m_serviceImplementations;
    private final IType m_serviceInterface;
    private ParameterField m_parameterArg1Field;
    private ParameterField m_parameterArg2Field;

    public ServiceOperationNewWizardPage(IType serviceInterface, IType[] serviceImplementations) {
        super(ServiceOperationNewWizardPage.class.getName());
        this.m_serviceInterface = serviceInterface;
        this.m_serviceImplementations = serviceImplementations;
        this.setTitle(Texts.get((String)"NewServiceOperationNoPopup"));
        this.setDescription(Texts.get((String)"CreateANewServiceOperation"));
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_operationNameField = new TextField(parent, 20);
        this.m_operationNameField.setLabelText(Texts.get((String)"OperationName"));
        this.m_operationNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceOperationNewWizardPage.this.m_operationName = ServiceOperationNewWizardPage.this.m_operationNameField.getText();
                ServiceOperationNewWizardPage.this.pingStateChanging();
            }
        });
        IScoutBundle interfaceBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_serviceInterface.getJavaProject());
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{interfaceBundle.getJavaProject()});
        this.m_returnParameterField = new ReturnParameterField(parent, 20, this.m_returnParameter, searchScope);
        this.m_returnParameterField.setLabel(Texts.get((String)"ReturnType"));
        this.m_returnParameterField.addParameterFieldListener(new IParameterFieldListener(){

            @Override
            public void parameterChanged(ParameterArgument argument) {
                ServiceOperationNewWizardPage.this.m_returnParameter = argument;
                ServiceOperationNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_parameterArg1Field = new ParameterField(parent, this.m_parameterArg1, searchScope);
        this.m_parameterArg1Field.setLabelParameterName(String.valueOf(Texts.get((String)"NameArg")) + " 1");
        this.m_parameterArg1Field.setLabelParameterType(Texts.get((String)"Type"));
        this.m_parameterArg1Field.addParameterFieldListener(new IParameterFieldListener(){

            @Override
            public void parameterChanged(ParameterArgument argument) {
                ServiceOperationNewWizardPage.this.m_parameterArg1 = argument;
                ServiceOperationNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_parameterArg2Field = new ParameterField(parent, this.m_parameterArg1, searchScope);
        this.m_parameterArg2Field.setLabelParameterName(String.valueOf(Texts.get((String)"NameArg")) + "2");
        this.m_parameterArg2Field.setLabelParameterType(Texts.get((String)"Type"));
        this.m_parameterArg2Field.addParameterFieldListener(new IParameterFieldListener(){

            @Override
            public void parameterChanged(ParameterArgument argument) {
                ServiceOperationNewWizardPage.this.m_parameterArg2 = argument;
                ServiceOperationNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_operationNameField.setLayoutData(new GridData(768));
        this.m_returnParameterField.setLayoutData(new GridData(768));
        this.m_parameterArg1Field.setLayoutData(new GridData(768));
        this.m_parameterArg2Field.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager manager) throws CoreException {
        ServiceOperationNewOperation op = new ServiceOperationNewOperation();
        ArrayList<ParameterArgument> args = new ArrayList<ParameterArgument>();
        if (this.m_parameterArg1 != null && !StringUtility.isNullOrEmpty((String)this.m_parameterArg1.getName()) && !StringUtility.isNullOrEmpty((String)this.m_parameterArg1.getType())) {
            args.add(this.m_parameterArg1);
        }
        if (this.m_parameterArg2 != null && !StringUtility.isNullOrEmpty((String)this.m_parameterArg2.getName()) && !StringUtility.isNullOrEmpty((String)this.m_parameterArg2.getType())) {
            args.add(this.m_parameterArg2);
        }
        if (this.m_parameterArg3 != null && !StringUtility.isNullOrEmpty((String)this.m_parameterArg3.getName()) && !StringUtility.isNullOrEmpty((String)this.m_parameterArg3.getType())) {
            args.add(this.m_parameterArg3);
        }
        if (this.m_parameterArg4 != null && !StringUtility.isNullOrEmpty((String)this.m_parameterArg4.getName()) && !StringUtility.isNullOrEmpty((String)this.m_parameterArg4.getType())) {
            args.add(this.m_parameterArg4);
        }
        if (this.m_parameterArg5 != null && !StringUtility.isNullOrEmpty((String)this.m_parameterArg5.getName()) && !StringUtility.isNullOrEmpty((String)this.m_parameterArg5.getType())) {
            args.add(this.m_parameterArg5);
        }
        op.setArguments(args.toArray(new ParameterArgument[args.size()]));
        op.setMethodName(this.m_operationName);
        op.setReturnType(this.m_returnParameter);
        op.setServiceImplementations(this.m_serviceImplementations);
        op.setServiceInterface(this.m_serviceInterface);
        op.run(monitor, manager);
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getOperationNameStatus());
        multiStatus.add(this.getReturnParameterStatus());
        if (this.m_parameterArg1 != null) {
            multiStatus.add(this.getParameterStatus(this.m_parameterArg1, this.m_parameterArg1Field.getLabel()));
        }
        if (this.m_parameterArg2 != null) {
            multiStatus.add(this.getParameterStatus(this.m_parameterArg1, this.m_parameterArg2Field.getLabel()));
        }
        super.validatePage(multiStatus);
    }

    protected IStatus getOperationNameStatus() {
        if (this.m_operationName == null || this.m_operationName.length() == 0) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"OperationNameMissing"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getReturnParameterStatus() {
        if (this.m_returnParameter == null || StringUtility.isNullOrEmpty((String)this.m_returnParameter.getType())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ReturnTypeMissing"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getParameterStatus(ParameterArgument arg, String fieldName) {
        if (StringUtility.isNullOrEmpty((String)arg.getName()) && !StringUtility.isNullOrEmpty((String)arg.getType())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ParameterXIsNotValid", (String[])new String[]{fieldName}));
        }
        if (!StringUtility.isNullOrEmpty((String)arg.getName()) && StringUtility.isNullOrEmpty((String)arg.getType())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ParameterXIsNotValid", (String[])new String[]{fieldName}));
        }
        return Status.OK_STATUS;
    }
}

