/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.wizard.step;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.WizardStepNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.Regex;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class WizardStepNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iWizardStep = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.wizard.IWizardStep");
    private static final String PROP_NLS_NAME = "nlsName";
    private static final String PROP_TYPE_NAME = "typeName";
    private static final String PROP_SUPER_TYPE = "superType";
    private static final String PROP_SIBLING = "sibling";
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_siblingField;
    private final IType m_abstractWizardStep;
    private final IType m_declaringType;
    private IType m_createdWizardStep;

    public WizardStepNewWizardPage(IType declaringType) {
        super(WizardStepNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewWizardStep"));
        this.setDescription(Texts.get((String)"CreateANewWizardStep"));
        this.m_declaringType = declaringType;
        this.m_abstractWizardStep = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.wizard.IWizardStep", (IJavaProject)this.m_declaringType.getJavaProject());
        this.setSuperTypeInternal(this.m_abstractWizardStep);
        this.setSibling(SiblingProposal.SIBLING_END);
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"Name"));
        this.m_nlsNameField.acceptProposal(this.getNlsName());
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    WizardStepNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = WizardStepNewWizardPage.this.getNlsName();
                    INlsEntry newEntry = (INlsEntry)event.proposal;
                    WizardStepNewWizardPage.this.setNlsNameInternal(newEntry);
                    if (newEntry != null && (oldEntry == null || oldEntry.getKey().equals(WizardStepNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)WizardStepNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        WizardStepNewWizardPage.this.m_typeNameField.setText(newEntry.getKey());
                    }
                }
                finally {
                    WizardStepNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Step");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardStepNewWizardPage.this.setTypeNameInternal(WizardStepNewWizardPage.this.m_typeNameField.getText());
                WizardStepNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iWizardStep, this.m_declaringType.getJavaProject(), this.m_abstractWizardStep));
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                WizardStepNewWizardPage.this.setSuperTypeInternal((IType)event.proposal);
                WizardStepNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createSiblingProposalField(parent, this.m_declaringType, this.iWizardStep);
        this.m_siblingField.acceptProposal(this.getSibling());
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                WizardStepNewWizardPage.this.setSiblingInternal((SiblingProposal)event.proposal);
                WizardStepNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        WizardStepNewOperation operation = new WizardStepNewOperation(this.m_declaringType, true);
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName());
        }
        operation.setTypeName(this.getTypeName());
        IType superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            operation.setSuperTypeSignature(SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName()));
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredWizard((IType)this.m_declaringType);
            operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_WIZARD_STEP));
        } else {
            operation.setSibling(this.getSibling().getElement());
        }
        operation.run(monitor, workingCopyManager);
        this.m_createdWizardStep = operation.getCreatedWizardStep();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        if (StringUtility.isNullOrEmpty((String)this.getTypeName()) || this.getTypeName().equals("Step")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_className"));
        }
        if (TypeUtility.exists((IJavaElement)this.m_declaringType.getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (Regex.REGEX_WELLFORMD_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return Status.OK_STATUS;
        }
        if (Regex.REGEX_JAVAFIELD.matcher(this.getTypeName()).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{this.getTypeName()}));
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IType getCreatedWizardStep() {
        return this.m_createdWizardStep;
    }

    public INlsEntry getNlsName() {
        return (INlsEntry)this.getProperty(PROP_NLS_NAME);
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.setNlsNameInternal(nlsName);
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNlsNameInternal(INlsEntry nlsName) {
        this.setProperty(PROP_NLS_NAME, nlsName);
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public SiblingProposal getSibling() {
        return (SiblingProposal)this.getProperty(PROP_SIBLING);
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.setSiblingInternal(sibling);
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSiblingInternal(SiblingProposal sibling) {
        this.setProperty(PROP_SIBLING, sibling);
    }
}

