/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.workingset;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.dialog.workingset.NewScoutWorkingSetDialog;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleComparators;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class ScoutWorkingSetWizardPage
extends WizardPage
implements IWorkingSetPage {
    private CheckableTree m_availableBundlesTree;
    private TextField m_nameField;
    private IWorkingSet m_currentWorkingSet;
    private boolean m_createNewSet;
    private String m_title;
    private String m_oldWorkingSetName;

    public ScoutWorkingSetWizardPage() {
        super(ScoutWorkingSetWizardPage.class.getName(), null, null);
        this.setMessage(Texts.get((String)"WorkingSetsMsg"));
    }

    public void createControl(Composite parent) {
        boolean bl = this.m_createNewSet = this.getSelection() == null;
        if (this.m_createNewSet) {
            this.setTitle(Texts.get((String)"NewScoutWorkingSet"));
        } else {
            this.setTitle(Texts.get((String)"ConfigureScoutWorkingSets"));
            this.m_oldWorkingSetName = this.getSelection().getName();
        }
        Composite p = new Composite(parent, 0);
        this.m_nameField = new TextField(p, String.valueOf(Texts.get((String)"Name")) + ":", 7);
        this.m_nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScoutWorkingSetWizardPage.this.validatePage();
            }
        });
        Label label = new Label(p, 0);
        label.setText(String.valueOf(Texts.get((String)"Content")) + ":");
        this.m_availableBundlesTree = new CheckableTree(p, this.createTree());
        this.m_availableBundlesTree.setDragDetect(false);
        if (!this.m_createNewSet) {
            this.m_nameField.setText(this.getSelection().getName());
            ArrayList<ITreeNode> checked = new ArrayList<ITreeNode>();
            IAdaptable[] iAdaptableArray = this.getSelection().getElements();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable a = iAdaptableArray[n2];
                ITreeNode[] candidates = TreeUtility.findNodes(this.m_availableBundlesTree.getRootNode(), NodeFilters.getByData(a));
                if (candidates != null && candidates.length > 0) {
                    ITreeNode[] iTreeNodeArray = candidates;
                    int n3 = candidates.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ITreeNode candidate = iTreeNodeArray[n4];
                        checked.add(candidate);
                        ++n4;
                    }
                }
                ++n2;
            }
            this.m_availableBundlesTree.setChecked(checked.toArray(new ITreeNode[checked.size()]));
        }
        p.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(4, 4, true, true);
        p.setLayoutData((Object)gd);
        gd = new GridData(1808);
        this.m_availableBundlesTree.setLayoutData(gd);
        gd = new GridData(768);
        this.m_nameField.setLayoutData(gd);
        this.setControl((Control)p);
    }

    private ITreeNode createTree() {
        IScoutBundle[] allBundles;
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setVisible(false);
        IScoutBundle[] iScoutBundleArray = allBundles = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getAllBundlesFilter(), ScoutBundleComparators.getSymbolicNameAscComparator());
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle b = iScoutBundleArray[n2];
            ITreeNode bundleNode = TreeUtility.createBundleTreeNode(rootNode, b);
            if (bundleNode != null) {
                bundleNode.setOrderNr(0);
                bundleNode.setCheckable(true);
            }
            ++n2;
        }
        return rootNode;
    }

    public void finish() {
        String workingSetName = this.m_nameField.getText().trim();
        ITreeNode[] checkedNodes = this.m_availableBundlesTree.getCheckedNodes();
        IAdaptable[] elements = new IAdaptable[checkedNodes.length];
        int i = 0;
        while (i < elements.length) {
            elements[i] = (IAdaptable)checkedNodes[i].getData();
            ++i;
        }
        if (this.m_createNewSet) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.setSelection(workingSetManager.createWorkingSet(workingSetName, elements));
        } else {
            this.getSelection().setName(workingSetName);
            this.getSelection().setElements(elements);
        }
    }

    private void validatePage() {
        String errorMessage = null;
        if (!NewScoutWorkingSetDialog.isValid(this.m_nameField.getText(), this.m_oldWorkingSetName)) {
            errorMessage = Texts.get((String)"NameNotValid");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public IWorkingSet getSelection() {
        return this.m_currentWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        this.m_currentWorkingSet = workingSet;
    }
}

