/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.sdk.operation.util.SourceFormatOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.jdt.SourceRange;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.TypeSelectionDialog;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.text.edits.ReplaceEdit;

public class InvalidServiceCommand
extends AbstractExecutableMarkerCommand {
    private IType m_type;
    private IFile m_stubJarFile;
    private IType m_serviceType;

    public InvalidServiceCommand(IType type, IFile stubJarFile) {
        super("Invalid service in super type generic parameter");
        this.m_type = type;
        this.m_stubJarFile = stubJarFile;
        this.setSolutionDescription("Use this task to fix service registration");
    }

    @Override
    public boolean prepareForUi() throws CoreException {
        IType[] candidates = JaxWsSdkUtility.resolveServiceTypes(null, this.m_stubJarFile);
        switch (candidates.length) {
            case 0: {
                MessageBox messageBox = new MessageBox(ScoutSdkUi.getShell(), 34);
                messageBox.setText(Texts.get("Information"));
                messageBox.setMessage(Texts.get("NoServicesFound"));
                messageBox.open();
                break;
            }
            case 1: {
                this.m_serviceType = candidates[0];
                break;
            }
            default: {
                TypeSelectionDialog dialog = new TypeSelectionDialog(ScoutSdkUi.getShell(), Texts.get("Service"), Texts.get("PleaseChooseServiceType"));
                dialog.setElements(Arrays.asList(candidates));
                if (dialog.open() != 0) break;
                this.m_serviceType = (IType)dialog.getElement();
            }
        }
        return this.m_serviceType != null;
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SourceRange insertionRange;
        ISourceRange classNameRange = this.m_type.getNameRange();
        int positionAfterClassName = classNameRange.getOffset() + classNameRange.getLength();
        String source = this.m_type.getCompilationUnit().getBuffer().getContents();
        String sourceAfterClassName = source.substring(positionAfterClassName);
        int insertPosition = -1;
        ReplaceEdit edit = null;
        Pattern pattern = Pattern.compile(String.valueOf(TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient").getElementName()) + "\\s*\\<\\s*([^\\,]*?)\\,([^\\>]*?)\\s*\\>");
        Matcher matcher = pattern.matcher(sourceAfterClassName);
        if (matcher.find()) {
            insertPosition = positionAfterClassName + matcher.start(1);
            insertionRange = new SourceRange(insertPosition, matcher.end(1) - matcher.start(1));
            edit = new ReplaceEdit(insertionRange.getOffset(), insertionRange.getLength(), this.m_serviceType.getElementName());
        } else {
            pattern = Pattern.compile(String.valueOf(TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient").getElementName()) + "\\s*\\<\\s*([^\\>]*?)\\>");
            matcher = pattern.matcher(sourceAfterClassName);
            if (matcher.find()) {
                insertPosition = positionAfterClassName + matcher.start(1);
                insertionRange = new SourceRange(insertPosition, matcher.end(1) - matcher.start(1));
                edit = new ReplaceEdit(insertionRange.getOffset(), insertionRange.getLength(), String.valueOf(this.m_serviceType.getElementName()) + ", Object");
            } else {
                pattern = Pattern.compile("(" + TypeUtility.getType((String)"org.eclipse.scout.jaxws.service.AbstractWebServiceClient").getElementName() + ")");
                matcher = pattern.matcher(sourceAfterClassName);
                if (matcher.find()) {
                    insertPosition = positionAfterClassName + matcher.end(1);
                    insertionRange = new SourceRange(insertPosition, 0);
                    edit = new ReplaceEdit(insertionRange.getOffset(), insertionRange.getLength(), "<" + this.m_serviceType.getElementName() + ", Object>");
                }
            }
        }
        if (edit == null) {
            throw new CoreException((IStatus)new ScoutStatus("Could not determine insert position for service type in type '" + this.m_type.getElementName() + "'"));
        }
        Document icuDoc = new Document(source);
        try {
            edit.apply((IDocument)icuDoc);
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new ScoutStatus("Failed to update interface declaration in type '" + this.m_type.getElementName() + "'", (Throwable)e));
        }
        ICompilationUnit icu = this.m_type.getCompilationUnit();
        workingCopyManager.register(icu, monitor);
        SourceFormatOperation sourceFormatOp = new SourceFormatOperation(this.m_type.getJavaProject(), icuDoc, null);
        sourceFormatOp.run(monitor, workingCopyManager);
        icu.getBuffer().setContents(ScoutUtility.cleanLineSeparator((String)icuDoc.get(), (Document)icuDoc));
        JaxWsSdkUtility.createImportDirective(this.m_type, this.m_serviceType);
        workingCopyManager.reconcile(this.m_type.getCompilationUnit(), monitor);
        workingCopyManager.unregister(icu, monitor);
    }
}

