/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class BindingFileCreateOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private IPath m_projectRelativePath;
    private IFile m_wsdlLocation;
    private String m_schemaTargetNamespace;
    private boolean m_createGlobalBindingSection;
    private IFolder m_wsdlDestinationFolder;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("no bundle set");
        }
        if (this.m_projectRelativePath == null) {
            throw new IllegalArgumentException("no projectRelativePath set");
        }
        if (this.m_wsdlDestinationFolder == null) {
            throw new IllegalArgumentException("WSDL destination path must not be null");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IFile bindingFile = JaxWsSdkUtility.getFile(this.m_bundle, this.m_projectRelativePath, true);
        ScoutXmlDocument xmlDocument = new ScoutXmlDocument();
        xmlDocument.setXmlVersion("1.0");
        xmlDocument.setXmlEncoding("UTF-8");
        xmlDocument.setPrettyPrint(true);
        ScoutXmlDocument.ScoutXmlElement rootXml = this.createBindingsRootNode(xmlDocument);
        xmlDocument.setRoot(rootXml);
        rootXml.setNamespace("jaxws", "http://java.sun.com/xml/ns/jaxws");
        rootXml.setNamespace("jaxb", "http://java.sun.com/xml/ns/jaxb");
        rootXml.setNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        rootXml.setNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        rootXml.setNamespace("xjc", "http://java.sun.com/xml/ns/jaxb/xjc");
        rootXml.setName("jaxws:bindings");
        rootXml.setAttribute("version", "2.0");
        if (this.m_wsdlLocation != null) {
            IPath wsdlFolderProjectRelativePath = this.m_wsdlDestinationFolder.getProjectRelativePath().makeRelativeTo(JaxWsSdkUtility.getParentFolder(this.m_bundle, bindingFile).getProjectRelativePath());
            rootXml.setAttribute("wsdlLocation", wsdlFolderProjectRelativePath.append(this.m_wsdlLocation.getName()).toString());
        }
        if (StringUtility.hasText((String)this.m_schemaTargetNamespace)) {
            rootXml.setAttribute("node", "wsdl:definitions/wsdl:types/xsd:schema[@targetNamespace='" + this.m_schemaTargetNamespace + "']");
        } else {
            rootXml.setAttribute("node", "wsdl:definitions/wsdl:types/xsd:schema");
        }
        if (this.isCreateGlobalBindingSection()) {
            ScoutXmlDocument.ScoutXmlElement globalBindingsXml = rootXml.addChild();
            globalBindingsXml.setName("jaxb:globalBindings");
            IType utcDateAdapterType = TypeUtility.getType((String)"org.eclipse.scout.jaxws.adapters.UtcDateAdapter");
            ScoutXmlDocument.ScoutXmlElement bindingJavaTypeXml = globalBindingsXml.addChild();
            bindingJavaTypeXml.setName("xjc:javaType");
            bindingJavaTypeXml.setAttribute("name", Date.class.getName());
            bindingJavaTypeXml.setAttribute("xmlType", "xsd:date");
            bindingJavaTypeXml.setAttribute("adapter", utcDateAdapterType.getFullyQualifiedName());
            bindingJavaTypeXml = globalBindingsXml.addChild();
            bindingJavaTypeXml.setName("xjc:javaType");
            bindingJavaTypeXml.setAttribute("name", Date.class.getName());
            bindingJavaTypeXml.setAttribute("xmlType", "xsd:time");
            bindingJavaTypeXml.setAttribute("adapter", utcDateAdapterType.getFullyQualifiedName());
            bindingJavaTypeXml = globalBindingsXml.addChild();
            bindingJavaTypeXml.setName("xjc:javaType");
            bindingJavaTypeXml.setAttribute("name", Date.class.getName());
            bindingJavaTypeXml.setAttribute("xmlType", "xsd:dateTime");
            bindingJavaTypeXml.setAttribute("adapter", utcDateAdapterType.getFullyQualifiedName());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            xmlDocument.write((OutputStream)os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            bindingFile.setContents((InputStream)is, true, false, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new ScoutStatus(4, "could not create binding file.", (Throwable)e));
        }
    }

    public String getOperationName() {
        return BindingFileCreateOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public IPath getProjectRelativePath() {
        return this.m_projectRelativePath;
    }

    public void setProjectRelativePath(IPath projectRelativePath) {
        this.m_projectRelativePath = projectRelativePath;
    }

    public IFile getWsdlLocation() {
        return this.m_wsdlLocation;
    }

    public void setWsdlLocation(IFile wsdlLocation) {
        this.m_wsdlLocation = wsdlLocation;
    }

    public String getSchemaTargetNamespace() {
        return this.m_schemaTargetNamespace;
    }

    public void setSchemaTargetNamespace(String schemaTargetNamespace) {
        this.m_schemaTargetNamespace = schemaTargetNamespace;
    }

    public boolean isCreateGlobalBindingSection() {
        return this.m_createGlobalBindingSection;
    }

    public void setCreateGlobalBindingSection(boolean createGlobalBindingSection) {
        this.m_createGlobalBindingSection = createGlobalBindingSection;
    }

    public IFolder getWsdlDestinationFolder() {
        return this.m_wsdlDestinationFolder;
    }

    public void setWsdlDestinationFolder(IFolder wsdlDestinationFolder) {
        this.m_wsdlDestinationFolder = wsdlDestinationFolder;
    }

    private ScoutXmlDocument.ScoutXmlElement createBindingsRootNode(ScoutXmlDocument xmlDocument) {
        ScoutXmlDocument scoutXmlDocument = xmlDocument;
        scoutXmlDocument.getClass();
        return new ScoutXmlDocument.ScoutXmlElement(scoutXmlDocument, "bindings"){
            private static final long serialVersionUID = 1L;

            protected void writeEncoded(BufferedWriter bufferedWriter, String string) throws IOException {
                if (string == null) {
                    return;
                }
                int i = 0;
                while (i < string.length()) {
                    char ch = string.charAt(i);
                    if (ch == '\'') {
                        bufferedWriter.write(ch);
                    } else {
                        String escaped = (String)ScoutXmlDocument.XML_ENTITIES.get(Character.valueOf(ch));
                        if (escaped != null) {
                            bufferedWriter.write(escaped);
                        } else {
                            bufferedWriter.write(ch);
                        }
                    }
                    ++i;
                }
            }
        };
    }
}

