/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.Document;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.ScoutTypeNewOperation;
import org.eclipse.scout.sdk.operation.util.SourceFormatOperation;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.internal.sigcache.SignatureCache;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class TypeNewOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private String m_typeName;
    private String m_packageName;
    private IType m_superType;
    private IType m_interfaceType;
    private IType m_createdType;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("bundle not set");
        }
        if (this.m_typeName == null) {
            throw new IllegalArgumentException("typeName not set");
        }
        if (this.m_packageName == null) {
            throw new IllegalArgumentException("packageName not set");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        ScoutTypeNewOperation opType = new ScoutTypeNewOperation(this.m_typeName, this.m_packageName, this.m_bundle);
        if (this.m_superType != null) {
            opType.setSuperTypeSignature(SignatureCache.createTypeSignature((String)this.m_superType.getFullyQualifiedName()));
        }
        if (this.m_interfaceType != null) {
            opType.addInterfaceSignature(SignatureCache.createTypeSignature((String)this.m_interfaceType.getFullyQualifiedName()));
        }
        opType.run(monitor, workingCopyManager);
        this.m_createdType = opType.getCreatedType();
        workingCopyManager.register(this.m_createdType.getCompilationUnit(), monitor);
        JaxWsSdkUtility.overrideUnimplementedMethodsAsync(this.m_createdType);
        ICompilationUnit icu = this.m_createdType.getCompilationUnit();
        Document icuDoc = new Document(icu.getBuffer().getContents());
        SourceFormatOperation sourceFormatOp = new SourceFormatOperation(this.m_createdType.getJavaProject(), icuDoc, null);
        sourceFormatOp.run(monitor, workingCopyManager);
        icu.getBuffer().setContents(ScoutUtility.cleanLineSeparator((String)icuDoc.get(), (Document)icuDoc));
        workingCopyManager.reconcile(icu, monitor);
    }

    public String getOperationName() {
        return TypeNewOperation.class.getName();
    }

    public IType getCreatedType() {
        return this.m_createdType;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }

    public void setPackageName(String packageName) {
        this.m_packageName = packageName;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public void setInterfaceType(IType interfaceType) {
        this.m_interfaceType = interfaceType;
    }
}

