/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.dialog;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.IMarkerCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class CommandExecutionDialog
extends TitleAreaDialog {
    private FormToolkit m_toolkit;
    private SelectionListener m_selectAllSelectionListener;
    private String m_dialogTitle;
    private String m_headerMessage;
    private IMarkerCommand[] m_commands;
    private Button m_selectAllButton;
    private Set<Button> m_commandSelectorFields;

    public CommandExecutionDialog(String dialogTitle) {
        super(ScoutSdkUi.getShell());
        this.m_dialogTitle = dialogTitle;
        this.m_toolkit = new FormToolkit(ScoutSdkUi.getDisplay());
        this.m_commandSelectorFields = new HashSet<Button>();
        this.setShellStyle(0x10870 | CommandExecutionDialog.getDefaultOrientation());
    }

    protected final void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.m_dialogTitle != null) {
            shell.setText(this.m_dialogTitle);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.m_headerMessage != null) {
            this.setMessage(this.m_headerMessage, 2);
        }
        this.setTitle(this.m_dialogTitle);
        this.setHelpAvailable(false);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        ScrolledForm form = this.m_toolkit.createScrolledForm(composite);
        form.setLayoutData((Object)new GridData(1808));
        Composite formBody = form.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.makeColumnsEqualWidth = true;
        tableWrapLayout.numColumns = 1;
        formBody.setLayout((Layout)tableWrapLayout);
        this.createCommandSections(formBody);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.m_selectAllButton = new Button(composite, 32);
        this.m_selectAllButton.setLayoutData((Object)new GridData(768));
        ((GridData)this.m_selectAllButton.getLayoutData()).verticalIndent = 5;
        ((GridData)this.m_selectAllButton.getLayoutData()).horizontalIndent = 16;
        this.m_selectAllButton.setText(Texts.get("SelectAll"));
        this.m_selectAllButton.setEnabled(this.hasExecutableCommands());
        this.m_selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Button button : CommandExecutionDialog.this.m_commandSelectorFields) {
                    button.setSelection(CommandExecutionDialog.this.m_selectAllButton.getSelection());
                    ((IMarkerCommand)button.getData()).setDoExecute(CommandExecutionDialog.this.m_selectAllButton.getSelection());
                }
            }
        });
        form.updateToolBar();
        form.reflow(true);
        return composite;
    }

    protected void createCommandSections(Composite parent) {
        IMarkerCommand[] iMarkerCommandArray = this.m_commands;
        int n = this.m_commands.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerCommand command = iMarkerCommandArray[n2];
            Composite section = this.createSection(parent, command.getProblemName(), command.getMarker().getAttribute("message", ""));
            int numOfColumns = 1;
            if (command.isExecutable()) {
                numOfColumns = 2;
            }
            section.setLayout((Layout)new GridLayout(numOfColumns, false));
            if (command.isExecutable()) {
                Button commandButton = this.m_toolkit.createButton(section, null, 32);
                this.m_commandSelectorFields.add(commandButton);
                GridData data = new GridData();
                data.verticalAlignment = 128;
                data.horizontalAlignment = 16384;
                commandButton.setLayoutData((Object)data);
                commandButton.setData((Object)command);
                commandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button checkBox = (Button)e.getSource();
                        IMarkerCommand cmd = (IMarkerCommand)checkBox.getData();
                        cmd.setDoExecute(checkBox.getSelection());
                        CommandExecutionDialog.this.checkForSelectAll();
                    }
                });
            }
            Text solutionField = new Text(section, 74);
            solutionField.setText(command.getSolutionDescription());
            GridData gridData = new GridData();
            gridData.widthHint = 550;
            solutionField.setLayoutData((Object)gridData);
            ++n2;
        }
    }

    private boolean hasExecutableCommands() {
        IMarkerCommand[] iMarkerCommandArray = this.m_commands;
        int n = this.m_commands.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerCommand command = iMarkerCommandArray[n2];
            if (command.isExecutable()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setCommands(IMarkerCommand[] commands) {
        this.m_commands = commands;
    }

    public void setHeaderMessage(String headerMessage) {
        this.m_headerMessage = headerMessage;
    }

    private void checkForSelectAll() {
        boolean selectAll = true;
        for (Button commandButton : this.m_commandSelectorFields) {
            selectAll = commandButton.getSelection();
            if (!selectAll) break;
        }
        this.m_selectAllButton.setSelection(selectAll);
    }

    private Composite createSection(Composite parent, String problemName, String problemDescription) {
        int style = 450;
        Section section = this.m_toolkit.createSection(parent, style);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setText(problemName);
        section.setDescription(problemDescription);
        Composite sectionClient = this.m_toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 30;
        sectionClient.setLayout((Layout)gridLayout);
        Composite commandComposite = this.m_toolkit.createComposite(sectionClient);
        commandComposite.setLayoutData((Object)new GridData(1808));
        return commandComposite;
    }
}

