/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.IResourceListener;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.ProviderNewWizardAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderCodeFirstNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class WebServiceProviderTablePage
extends AbstractPage {
    private IScoutBundle m_bundle;
    private ScoutXmlDocument m_sunJaxWsXml;
    private IResourceListener m_resourceListener;

    public WebServiceProviderTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get("Services"));
        this.setImageDescriptor(JaxWsSdk.getImageDescriptor("webservice_folder.png"));
        this.m_bundle = this.getScoutBundle();
        this.m_resourceListener = new P_SunJaxWsResourceListener();
        this.getSunJaxWsResource().addResourceListener(this.m_resourceListener);
    }

    public String getPageId() {
        return IJaxWsPageConstants.WEBSERVICE_PROVIDER_TABLE_PAGE;
    }

    public boolean isFolder() {
        return true;
    }

    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof ProviderNewWizardAction) {
            ((ProviderNewWizardAction)menu).init(this.m_bundle);
        }
    }

    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{ProviderNewWizardAction.class};
    }

    public void unloadPage() {
        this.getSunJaxWsResource().removeResourceListener(this.m_resourceListener);
        super.unloadPage();
    }

    public void refresh(boolean clearCache) {
        if (clearCache) {
            this.m_sunJaxWsXml = null;
        }
        super.refresh(clearCache);
    }

    protected void loadChildrenImpl() {
        if (this.m_sunJaxWsXml == null) {
            this.m_sunJaxWsXml = this.getSunJaxWsResource().loadXml();
        }
        for (ScoutXmlDocument.ScoutXmlElement sunJaxWsXml : this.getEndpoints()) {
            SunJaxWsBean sunJaxWsBean = new SunJaxWsBean(sunJaxWsXml);
            BuildJaxWsBean buildJaxWsBean = BuildJaxWsBean.load(this.m_bundle, sunJaxWsBean.getAlias(), WebserviceEnum.Provider);
            if (buildJaxWsBean != null) {
                new WebServiceProviderNodePage((IPage)this, sunJaxWsBean.getAlias());
                continue;
            }
            new WebServiceProviderCodeFirstNodePage((IPage)this, sunJaxWsBean);
        }
    }

    private final XmlResource getSunJaxWsResource() {
        return ResourceFactory.getSunJaxWsResource(this.m_bundle);
    }

    private List<ScoutXmlDocument.ScoutXmlElement> getEndpoints() {
        if (this.m_sunJaxWsXml == null || this.m_sunJaxWsXml.getRoot() == null) {
            return Collections.emptyList();
        }
        return this.m_sunJaxWsXml.getRoot().getChildren(StringUtility.join((String)":", (Object[])new Object[]{this.m_sunJaxWsXml.getRoot().getNamePrefix(), "endpoint"}));
    }

    private class P_SunJaxWsResourceListener
    implements IResourceListener {
        private P_SunJaxWsResourceListener() {
        }

        private boolean isContentAvailable(IFile file) {
            File osFile = file.getRawLocation().makeAbsolute().toFile();
            return osFile.length() > 0L;
        }

        @Override
        public void changed(String element, int event) {
            if (!this.isContentAvailable(WebServiceProviderTablePage.this.getSunJaxWsResource().getFile())) {
                return;
            }
            WebServiceProviderTablePage.this.m_sunJaxWsXml = WebServiceProviderTablePage.this.getSunJaxWsResource().loadXml();
            HashSet<String> endpoints = new HashSet<String>();
            HashSet<String> endpointsLoaded = new HashSet<String>();
            for (ScoutXmlDocument.ScoutXmlElement sunJaxWsXml : WebServiceProviderTablePage.this.getEndpoints()) {
                SunJaxWsBean sunJaxWsBean = new SunJaxWsBean(sunJaxWsXml);
                endpoints.add(sunJaxWsBean.getAlias());
            }
            for (IPage page : WebServiceProviderTablePage.this.getChildren()) {
                if (!(page instanceof WebServiceProviderNodePage)) continue;
                endpointsLoaded.add(((WebServiceProviderNodePage)page).getAlias());
            }
            if (!endpointsLoaded.equals(endpoints)) {
                JaxWsSdkUtility.markStructureDirtyAndFixSelection((IPage)WebServiceProviderTablePage.this);
            }
        }
    }
}

