/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class WsStubWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_STUB_FOLDER = "stubFolder";
    public static final String PROP_PACKAGE = "package";
    public static final String PROP_CREATE_BINDING_FILE = "createBindingFile";
    private BasicPropertySupport m_propertySupport;
    private IScoutBundle m_bundle;
    private StyledTextField m_packageField;
    private Button m_packageBrowseButton;
    private Button m_createBindingFileButton;
    private String m_serviceName;
    private String m_defaultPackageName;

    public WsStubWizardPage(IScoutBundle bundle) {
        super(WsStubWizardPage.class.getName());
        this.setTitle(Texts.get("ConfigureWebServiceStub"));
        this.setDescription(Texts.get("ConfigureWebServiceStub"));
        this.m_bundle = bundle;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.applyDefaults();
    }

    private void applyDefaults() {
        this.setCreateBindingFile(true);
    }

    protected void createContent(Composite parent) {
        this.m_packageField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("StubPackage"));
        this.m_packageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsStubWizardPage.this.setPackageNameInternal(WsStubWizardPage.this.m_packageField.getText());
                WsStubWizardPage.this.pingStateChanging();
            }
        });
        this.m_packageBrowseButton = new Button(parent, 0x800008);
        this.m_packageBrowseButton.setText(Texts.get("Browse"));
        this.m_packageBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment[] packageFragment = WsStubWizardPage.this.openBrowsePackagesDialog();
                if (packageFragment != null && packageFragment.length > 0) {
                    WsStubWizardPage.this.setPackageName(packageFragment[0].getElementName());
                }
            }
        });
        this.m_createBindingFileButton = new Button(parent, 32);
        this.m_createBindingFileButton.setText(Texts.get("CreateBindingFile"));
        this.m_createBindingFileButton.setSelection(this.isCreateBindingFile());
        this.m_createBindingFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WsStubWizardPage.this.setCreateBindingFileInternal(WsStubWizardPage.this.m_createBindingFileButton.getSelection());
            }
        });
        parent.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_packageField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_packageField, 0, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_packageBrowseButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_packageBrowseButton, 5, 1024);
        formData.left = new FormAttachment(40, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_createBindingFileButton.setLayoutData((Object)formData);
    }

    protected void validatePage(MultiStatus multiStatus) {
        if (this.m_bundle == null) {
            return;
        }
        this.validatePackage(multiStatus);
    }

    public void setPackageName(String packageName) {
        try {
            this.setStateChanging(true);
            this.setPackageNameInternal(packageName);
            if (this.isControlCreated()) {
                this.m_packageField.setText(StringUtility.nvl((Object)packageName, (String)""));
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setPackageNameInternal(String packageName) {
        this.m_propertySupport.setProperty(PROP_PACKAGE, (Object)packageName);
    }

    public String getPackageName() {
        return this.m_propertySupport.getPropertyString(PROP_PACKAGE);
    }

    public String getDefaultPackageName() {
        return this.m_defaultPackageName;
    }

    public void setDefaultPackageName(String defaultPackageName) {
        this.m_defaultPackageName = defaultPackageName;
    }

    public void setCreateBindingFile(boolean createBindingFile) {
        try {
            this.setStateChanging(true);
            this.setCreateBindingFileInternal(createBindingFile);
            if (this.isControlCreated()) {
                this.m_createBindingFileButton.setSelection(createBindingFile);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setCreateBindingFileInternal(boolean createBindingFile) {
        this.m_propertySupport.setPropertyBool(PROP_CREATE_BINDING_FILE, createBindingFile);
    }

    public boolean isCreateBindingFile() {
        return this.m_propertySupport.getPropertyBool(PROP_CREATE_BINDING_FILE);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    private IPackageFragment[] openBrowsePackagesDialog() {
        IPackageFragment[] packageFragments = null;
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.m_bundle.getJavaProject()});
        SelectionDialog dialog = JavaUI.createPackageDialog((Shell)ScoutSdkUi.getShell(), (IRunnableContext)context, (IJavaSearchScope)searchScope, (boolean)false, (boolean)true, null);
        dialog.setTitle(Texts.get("Package"));
        dialog.setMessage(Texts.get("ChoosePackageForImplementingClass"));
        if (dialog.open() == 0 && dialog.getResult() != null) {
            packageFragments = Arrays.asList(dialog.getResult()).toArray(new IPackageFragment[0]);
        }
        if (packageFragments != null) {
            return packageFragments;
        }
        return null;
    }

    private void validatePackage(MultiStatus multiStatus) {
        if (!StringUtility.hasText((String)this.getPackageName()) && this.m_defaultPackageName == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("JaxWsCannotDerivePackageNameFromTargetNamespace")));
        }
        if (!CompareUtility.equals((Object)this.m_defaultPackageName, (Object)this.getPackageName())) {
            multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("ConventionPackageNameEqualsToTargetNamespaceX")));
            multiStatus.add(JavaConventionsUtil.validatePackageName((String)this.getPackageName(), (IJavaElement)this.m_bundle.getJavaProject()));
            if (StringUtility.isNullOrEmpty((String)this.getPackageName())) {
                multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("UsageOfDefaultPackageDiscouraged")));
            }
        }
    }
}

