package @@BUNDLE_SWT_NAME@@.application;

import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.scout.net.NetActivator;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/** <h3>Activator</h3>
 *  This class controls all aspects of the application's execution
 */
public class Application implements IApplication {

  @Override
  public Object start(final IApplicationContext context) throws Exception {
    Subject subject = new Subject();
    subject.getPrincipals().add(new SimplePrincipal(System.getProperty("user.name")));
    return Subject.doAs(subject, new PrivilegedExceptionAction<Object>() {
      @Override
      public Object run() throws Exception {
        return startSecure(context);
      }
    });
  }

  public Integer startSecure(final IApplicationContext context) throws Exception {
    Display display = PlatformUI.createDisplay();
    NetActivator.install();
    if (PlatformUI.createAndRunWorkbench(display, new ApplicationWorkbenchAdvisor()) == PlatformUI.RETURN_RESTART) {
      return EXIT_RESTART;
    }
    return EXIT_OK;
  }

  @Override
  public void stop() {
    final IWorkbench workbench = PlatformUI.getWorkbench();
    if (workbench == null) return;
    final Display display = workbench.getDisplay();
    display.syncExec(new Runnable() {
      @Override
      public void run() {
        if (!display.isDisposed())
          workbench.close();
        }
    });
  }
}
