/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.core.common.internal.xmleditor.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.soa.sca.core.common.internal.xmleditor.completion.AbstractProposalProcessor;
import org.eclipse.soa.sca.core.common.utils.DomUtils;
import org.eclipse.soa.sca.core.common.utils.ResourceUtils;
import org.eclipse.soa.sca.core.common.utils.ScaXmlIncludesUtils;
import org.eclipse.soa.sca.core.common.utils.ScaXmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueProposalProcessor
extends AbstractProposalProcessor {
    private IFile editedFile;
    private ScaXmlIncludesUtils includesUtils;
    private final Map<String, String> generatedNsUriToPrefix = new HashMap<String, String>();

    @Override
    public List<ICompletionProposal> computeCompletionProposals(AbstractProposalProcessor.Location location) {
        int index;
        if (this.editedFile == null) {
            this.initializeInclusionElements();
        }
        if (this.markupName == null || this.attributeName == null || location == AbstractProposalProcessor.Location.afterElement) {
            return Collections.emptyList();
        }
        if (location != AbstractProposalProcessor.Location.inAttributeValue) {
            return Collections.emptyList();
        }
        if (this.attributeValue == null) {
            this.attributeValue = "";
        }
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < this.textAfterOffset.length()) {
            char c = this.textAfterOffset.charAt(j);
            if (c == '\'' || c == '\"' || c == '>' || c == '\n' || c == '\r') break;
            buf.append(c);
            ++j;
        }
        if ((index = this.markupName.lastIndexOf(58)) >= 0) {
            this.markupName = index < this.markupName.length() - 1 ? this.markupName.substring(index + 1) : "";
        }
        return this.makeProposals(this.markupName, this.attributeName, this.attributeValue, buf.toString());
    }

    private void initializeInclusionElements() {
        this.editedFile = ResourceUtils.getIFileFromEditor();
        IProject project = this.editedFile.getProject();
        this.includesUtils = ScaXmlIncludesUtils.createIncludesUtils(project);
    }

    public List<ICompletionProposal> makeProposals(String markupName, String attributeName, String attributeValue, String remainingAttributeValue) {
        if ("service".equalsIgnoreCase(markupName)) {
            return this.provideServiceMarkupProposals(attributeName, attributeValue, remainingAttributeValue);
        }
        if ("reference".equalsIgnoreCase(markupName)) {
            return this.provideReferenceMarkupProposals(attributeName, attributeValue, remainingAttributeValue);
        }
        if ("wire".equalsIgnoreCase(markupName)) {
            return this.provideWireMarkupProposals(attributeName, attributeValue, remainingAttributeValue);
        }
        if ("include".equalsIgnoreCase(markupName)) {
            return this.provideIncludesMarkupProposals(attributeName, attributeValue, remainingAttributeValue);
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> provideWireMarkupProposals(String attributeName, String attributeValue, String remainingAttributeValue) {
        ArrayList<ICompletionProposal> result;
        block5: {
            String[] serviceNames;
            block4: {
                String[] referenceNames;
                result = new ArrayList<ICompletionProposal>();
                if (!"source".equalsIgnoreCase(attributeName)) break block4;
                String[] stringArray = referenceNames = ScaXmlUtils.getPromotions(this.element.getOwnerDocument(), false);
                int n = referenceNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String referenceName = stringArray[n2];
                    if (referenceName.startsWith(attributeValue)) {
                        int replacementLength = attributeValue.length() + remainingAttributeValue.length();
                        result.add((ICompletionProposal)new CompletionProposal(referenceName, this.offset - attributeValue.length(), replacementLength, referenceName.length()));
                    }
                    ++n2;
                }
                break block5;
            }
            if (!"target".equalsIgnoreCase(attributeName)) break block5;
            String[] stringArray = serviceNames = ScaXmlUtils.getPromotions(this.element.getOwnerDocument(), true);
            int n = serviceNames.length;
            int n3 = 0;
            while (n3 < n) {
                String serviceName = stringArray[n3];
                if (serviceName.startsWith(attributeValue)) {
                    int replacementLength = attributeValue.length() + remainingAttributeValue.length();
                    result.add((ICompletionProposal)new CompletionProposal(serviceName, this.offset - attributeValue.length(), replacementLength, serviceName.length()));
                }
                ++n3;
            }
        }
        return result;
    }

    private List<ICompletionProposal> provideReferenceMarkupProposals(String attributeName, String attributeValue, String remainingAttributeValue) {
        String[] referenceNames = "promote".equalsIgnoreCase(attributeName) ? ScaXmlUtils.getPromotions(this.element.getOwnerDocument(), false) : ("target".equalsIgnoreCase(attributeName) ? ScaXmlUtils.getPromotions(this.element.getOwnerDocument(), true) : new String[]{});
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        String[] stringArray = referenceNames;
        int n = referenceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String referenceName = stringArray[n2];
            if (referenceName.startsWith(attributeValue)) {
                int replacementLength = attributeValue.length() + remainingAttributeValue.length();
                result.add((ICompletionProposal)new CompletionProposal(referenceName, this.offset - attributeValue.length(), replacementLength, referenceName.length()));
            }
            ++n2;
        }
        return result;
    }

    private List<ICompletionProposal> provideServiceMarkupProposals(String attributeName, String attributeValue, String remainingAttributeValue) {
        String[] serviceNames = "promote".equalsIgnoreCase(attributeName) ? ScaXmlUtils.getPromotions(this.element.getOwnerDocument(), true) : new String[]{};
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        String[] stringArray = serviceNames;
        int n = serviceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String serviceName = stringArray[n2];
            if (serviceName.startsWith(attributeValue)) {
                int replacementLength = attributeValue.length() + remainingAttributeValue.length();
                result.add((ICompletionProposal)new CompletionProposal(serviceName, this.offset - attributeValue.length(), replacementLength, serviceName.length()));
            }
            ++n2;
        }
        return result;
    }

    private List<QName> getIncludedFiles(Document domDoc) {
        ArrayList<QName> includeQNames = new ArrayList<QName>();
        NodeList includes = domDoc.getElementsByTagNameNS("*", "include");
        int i = 0;
        while (i < includes.getLength()) {
            QName includeQName = ScaXmlUtils.getIncludeQName(includes.item(i));
            if (includeQName != null) {
                includeQNames.add(includeQName);
            }
            ++i;
        }
        return includeQNames;
    }

    private List<ICompletionProposal> provideIncludesMarkupProposals(String attributeName, String attributeValue, String remainingAttributeValue) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        try {
            this.initializeInclusionElements();
            List<QName> alreadyIncluded = this.getIncludedFiles(this.element.getOwnerDocument());
            QName currentQName = this.includesUtils.getQName(this.editedFile);
            if (currentQName != null) {
                alreadyIncluded.add(currentQName);
            }
            ArrayList<QName> possibleInclusions = new ArrayList<QName>(this.includesUtils.getQNames());
            possibleInclusions.removeAll(alreadyIncluded);
            for (QName qName : possibleInclusions) {
                String nsUri = qName.getNamespaceURI();
                String nsPrefix = this.element.lookupPrefix(nsUri);
                if (nsPrefix == null && (nsPrefix = this.generatedNsUriToPrefix.get(nsUri)) == null) {
                    nsPrefix = this.generateNamespacePrefix(nsUri, String.valueOf(attributeValue) + remainingAttributeValue);
                }
                String proposal = nsPrefix.length() == 0 ? qName.getLocalPart() : (this.generatedNsUriToPrefix.containsKey(nsUri) ? String.valueOf(nsPrefix) + ":" + qName.getLocalPart() + "\" xmlns:" + nsPrefix + "=\"" + qName.getNamespaceURI() : String.valueOf(nsPrefix) + ":" + qName.getLocalPart());
                if (!qName.getLocalPart().startsWith(attributeValue) && !nsPrefix.startsWith(attributeValue)) continue;
                int replacementLength = attributeValue.length() + remainingAttributeValue.length();
                result.add((ICompletionProposal)new CompletionProposal(proposal, this.offset - attributeValue.length(), replacementLength, proposal.length(), null, qName.getLocalPart(), null, "<b>{" + qName.getNamespaceURI() + "}</b> " + qName.getLocalPart()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String generateNamespacePrefix(String nsUri, String completeAttributeValue) {
        int num = this.generatedNsUriToPrefix.size();
        String nsPrefix = "include" + num;
        boolean correctPrefix = false;
        while (!correctPrefix) {
            String associatedUri = DomUtils.lookupNamespaceURI(nsPrefix, this.element);
            if (associatedUri != null) {
                if (!nsUri.equals(associatedUri)) {
                    nsPrefix = "include" + ++num;
                    continue;
                }
                correctPrefix = true;
                continue;
            }
            if (completeAttributeValue.startsWith(nsPrefix)) {
                nsPrefix = "include" + ++num;
                continue;
            }
            correctPrefix = true;
        }
        this.generatedNsUriToPrefix.put(nsUri, nsPrefix);
        return nsPrefix;
    }
}

