/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.common.utils;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.soa.sca.sca1_0.common.utils.ScaCompositeUtils;
import org.eclipse.soa.sca.sca1_0.model.sca.Component;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_0.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.DocumentRoot;
import org.eclipse.soa.sca.sca1_0.model.sca.Reference;
import org.eclipse.soa.sca.sca1_0.model.sca.SCAImplementation;
import org.eclipse.soa.sca.sca1_0.model.sca.ScaFactory;
import org.eclipse.soa.sca.sca1_0.model.sca.ScaPackage;
import org.eclipse.soa.sca.sca1_0.model.sca.Service;
import org.eclipse.soa.sca.sca1_0.model.sca.util.ScaResourceFactoryImpl;

public class CompositeShellGenerator {
    private final IFile compositeFile;
    private final IFile destCompositeFile;

    public CompositeShellGenerator(IFile compositeFileC, IFile destCompositeFileC) {
        this.compositeFile = compositeFileC;
        this.destCompositeFile = destCompositeFileC;
    }

    public void createCompositeShell() {
        Composite initialComposite = ScaCompositeUtils.getComposite((IResource)this.compositeFile);
        if (initialComposite != null) {
            this.createCompositeShell(initialComposite);
        }
    }

    private boolean createCompositeShell(Composite initialComposite) {
        boolean result = false;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ScaResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.osoa.org/xmlns/sca/1.0", (Object)ScaPackage.eINSTANCE);
        URI uri = URI.createFileURI((String)this.destCompositeFile.getFullPath().toString());
        try {
            Resource resource = resourceSet.createResource(uri);
            DocumentRoot documentRoot = ScaFactory.eINSTANCE.createDocumentRoot();
            Composite composite = this.createComposite(initialComposite);
            documentRoot.setComposite(composite);
            Component component = this.createComponent(initialComposite);
            composite.getComponent().add((Object)component);
            for (Service initialService : initialComposite.getService()) {
                this.createService(initialService, composite, component);
            }
            for (Reference initialReference : initialComposite.getReference()) {
                this.createReference(initialReference, composite, component);
            }
            resource.getContents().add((Object)documentRoot);
            resource.save(null);
            result = true;
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return result;
    }

    private void createReference(Reference initialReference, Composite composite, Component component) {
        Reference compositeReference = ScaFactory.eINSTANCE.createReference();
        compositeReference.setName(initialReference.getName());
        composite.getReference().add((Object)compositeReference);
        ComponentReference componentReference = ScaFactory.eINSTANCE.createComponentReference();
        componentReference.setName(initialReference.getName());
        component.getReference().add((Object)componentReference);
        compositeReference.getPromote().add((Object)componentReference);
    }

    private void createService(Service initialService, Composite composite, Component component) {
        Service compositeService = ScaFactory.eINSTANCE.createService();
        compositeService.setName(initialService.getName());
        composite.getService().add((Object)compositeService);
        ComponentService componentService = ScaFactory.eINSTANCE.createComponentService();
        componentService.setName(initialService.getName());
        component.getService().add((Object)componentService);
        compositeService.setPromote(componentService);
    }

    private Component createComponent(Composite initialComposite) {
        Component component = ScaFactory.eINSTANCE.createComponent();
        component.setName(initialComposite.getName());
        SCAImplementation scaImplementation = ScaFactory.eINSTANCE.createSCAImplementation();
        QName internalCompositeName = new QName(initialComposite.getTargetNamespace(), initialComposite.getName());
        scaImplementation.setName(internalCompositeName);
        ((FeatureMap.Internal)component.getImplementationGroup()).clear();
        ((FeatureMap.Internal)component.getImplementationGroup()).add((EStructuralFeature)ScaPackage.Literals.COMPONENT__IMPLEMENTATION_GROUP, (Object)FeatureMapUtil.createEntry((EStructuralFeature)ScaPackage.Literals.DOCUMENT_ROOT__IMPLEMENTATION_COMPOSITE, (Object)scaImplementation));
        return component;
    }

    private Composite createComposite(Composite initialComposite) {
        Composite composite = ScaFactory.eINSTANCE.createComposite();
        composite.setName(this.destCompositeFile.getName().replaceAll("." + this.destCompositeFile.getFileExtension(), ""));
        composite.setTargetNamespace(initialComposite.getTargetNamespace());
        return composite;
    }
}

