/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.customactions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_0.diagram.edit.parts.CompositeEditPart;
import org.eclipse.soa.sca.sca1_0.model.sca.BaseReference;
import org.eclipse.soa.sca.sca1_0.model.sca.BaseService;
import org.eclipse.soa.sca.sca1_0.model.sca.Binding;
import org.eclipse.soa.sca.sca1_0.model.sca.Component;
import org.eclipse.soa.sca.sca1_0.model.sca.Composite;
import org.eclipse.soa.sca.sca1_0.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_0.model.sca.Interface;
import org.eclipse.soa.sca.sca1_0.model.sca.JavaImplementation;
import org.eclipse.soa.sca.sca1_0.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_0.model.sca.SCAImplementation;
import org.eclipse.soa.sca.sca1_0.model.sca.WSDLPortType;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.datatransfer.ZipFileExportWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportCompositeAction
extends Action
implements IActionDelegate {
    private CompositeEditPart myPart;

    public void run(IAction action) {
        ArrayList<IFile> filesToPut = new ArrayList<IFile>();
        filesToPut.add(this.getCompositeFile());
        this.parseComposite(filesToPut);
        StructuredSelection slt = new StructuredSelection(filesToPut.toArray());
        ZipFileExportWizard wizard = new ZipFileExportWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)slt);
        Display display = Display.getCurrent();
        Shell shell = new Shell(display, 1268);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private IFile getCompositeFile() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        IEditorInput input = editor.getEditorInput();
        IPath path = ((FileEditorInput)input).getPath();
        path = path.removeFirstSegments(2);
        path = path.removeFileExtension();
        path = path.addFileExtension("composite");
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    private void parseImplementation(List<IFile> result, Implementation implementation) {
        IFile f = null;
        if (implementation instanceof JavaImplementation) {
            f = this.resolveFile(((JavaImplementation)implementation).getClass_());
        } else {
            boolean cfr_ignored_0 = implementation instanceof SCAImplementation;
        }
        if (f != null) {
            result.add(f);
        }
    }

    private void parseInterface(List<IFile> result, Interface interfaze) {
        IFile f = null;
        if (interfaze instanceof JavaInterface) {
            f = this.resolveFile(((JavaInterface)interfaze).getInterface());
        } else if (interfaze instanceof WSDLPortType) {
            f = this.resolveFile(((WSDLPortType)interfaze).getInterface());
        }
        if (f != null) {
            result.add(f);
        }
    }

    private void parseBindings(List<IFile> result, List<Binding> bindings) {
        for (Binding binding : bindings) {
            IFile f = this.resolveFile(binding.getName());
            if (f == null) continue;
            result.add(f);
        }
    }

    private void parseServices(List<IFile> result, List<?> services) {
        for (BaseService service : services) {
            if (service.getInterface() != null) {
                this.parseInterface(result, service.getInterface());
            }
            if (service.getBinding() == null) continue;
            this.parseBindings(result, (List<Binding>)service.getBinding());
        }
    }

    private void parseReferences(List<IFile> result, List<?> references) {
        for (BaseReference reference : references) {
            if (reference.getInterface() != null) {
                this.parseInterface(result, reference.getInterface());
            }
            if (reference.getBinding() == null) continue;
            this.parseBindings(result, (List<Binding>)reference.getBinding());
        }
    }

    private IFile resolveFile(String name) {
        IFile f = null;
        try {
            Path path = new Path(name);
            f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        catch (Exception exception) {}
        return f;
    }

    private void parseComponents(List<IFile> result, List<Component> components) {
        for (Component component : components) {
            if (component.getImplementation() != null) {
                this.parseImplementation(result, component.getImplementation());
            }
            if (component.getService() != null) {
                this.parseServices(result, (List<?>)component.getService());
            }
            if (component.getReference() == null) continue;
            this.parseReferences(result, (List<?>)component.getReference());
        }
    }

    private void parseComposite(List<IFile> result) {
        Composite composite = (Composite)this.myPart.resolveSemanticElement();
        if (composite.getService() != null) {
            this.parseServices(result, (List<?>)composite.getService());
        }
        if (composite.getReference() != null) {
            this.parseReferences(result, (List<?>)composite.getReference());
        }
        if (composite.getComponent() != null) {
            this.parseComponents(result, (List<Component>)composite.getComponent());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection iss;
        if (selection instanceof IStructuredSelection && (iss = (IStructuredSelection)selection).getFirstElement() instanceof CompositeEditPart) {
            this.myPart = (CompositeEditPart)((Object)iss.getFirstElement());
        }
    }
}

