/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_0.diagram.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soa.sca.sca1_0.diagram.Messages;
import org.eclipse.soa.sca.sca1_0.diagram.navigator.ScaNavigatorItem;
import org.eclipse.soa.sca.sca1_0.diagram.part.ScaDiagramEditorPlugin;
import org.eclipse.soa.sca.sca1_0.diagram.part.ScaVisualIDRegistry;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.part.FileEditorInput;

public class ScaNavigatorActionProvider
extends CommonActionProvider {
    private boolean myContribute;
    private OpenDiagramAction myOpenDiagramAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        if (aSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.myContribute = true;
            this.makeActions((ICommonViewerWorkbenchSite)aSite.getViewSite());
        } else {
            this.myContribute = false;
        }
    }

    private void makeActions(ICommonViewerWorkbenchSite viewerSite) {
        this.myOpenDiagramAction = new OpenDiagramAction(viewerSite);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.myContribute) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.myOpenDiagramAction.selectionChanged(selection);
        if (this.myOpenDiagramAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.myOpenDiagramAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
    }

    private static class OpenDiagramAction
    extends Action {
        private Diagram myDiagram;
        private ICommonViewerWorkbenchSite myViewerSite;

        public OpenDiagramAction(ICommonViewerWorkbenchSite viewerSite) {
            super(Messages.NavigatorActionProvider_OpenDiagramActionName);
            this.myViewerSite = viewerSite;
        }

        public final void selectionChanged(IStructuredSelection selection) {
            this.myDiagram = null;
            if (selection.size() == 1) {
                Diagram diagram;
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof ScaNavigatorItem) {
                    selectedElement = ((ScaNavigatorItem)((Object)selectedElement)).getView();
                } else if (selectedElement instanceof IAdaptable) {
                    selectedElement = ((IAdaptable)selectedElement).getAdapter(View.class);
                }
                if (selectedElement instanceof Diagram && "Sca".equals(ScaVisualIDRegistry.getModelID((View)(diagram = (Diagram)selectedElement)))) {
                    this.myDiagram = diagram;
                }
            }
            this.setEnabled(this.myDiagram != null);
        }

        public void run() {
            if (this.myDiagram == null || this.myDiagram.eResource() == null) {
                return;
            }
            IEditorInput editorInput = OpenDiagramAction.getEditorInput(this.myDiagram);
            IWorkbenchPage page = this.myViewerSite.getPage();
            try {
                page.openEditor(editorInput, "org.eclipse.soa.sca.sca1_0.diagram.part.ScaDiagramEditorID");
            }
            catch (PartInitException e) {
                ScaDiagramEditorPlugin.getInstance().logError("Exception while openning diagram", e);
            }
        }

        private static IEditorInput getEditorInput(Diagram diagram) {
            Resource diagramResource = diagram.eResource();
            for (EObject nextEObject : diagramResource.getContents()) {
                if (nextEObject == diagram) {
                    return new FileEditorInput(WorkspaceSynchronizer.getFile((Resource)diagramResource));
                }
                if (nextEObject instanceof Diagram) break;
            }
            URI uri = EcoreUtil.getURI((EObject)diagram);
            String editorName = String.valueOf(uri.lastSegment()) + '#' + diagram.eResource().getContents().indexOf((Object)diagram);
            URIEditorInput editorInput = new URIEditorInput(uri, editorName);
            return editorInput;
        }
    }
}

