/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soa.sca.sca1_1.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.soa.sca.sca1_1.common.utils.ScaModelUtils;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Include;
import org.eclipse.soa.sca.sca1_1.model.sca.Property;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.soa.sca.sca1_1.model.sca.Wire;
import org.eclipse.soa.sca.sca1_1.model.sca.impl.CompositeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperComposite
extends CompositeImpl {
    private final Composite mainComposite;
    private final IContainer[] rootContainers;
    private final ScaModelUtils scaModelUtils;
    private List<SuperComposite> resolvedInclusions;
    private List<Include> unresolvedInclusions;
    private List<Service> includedServices;
    private List<Reference> includedReferences;
    private List<Property> includedProperties;
    private List<Component> includedComponents;
    private List<Service> implementationServices;
    private List<Reference> implementationReferences;
    private List<Property> implementationProperties;

    public SuperComposite(IFile mainCompositeFile, IContainer[] rootContainers, ScaModelUtils scaModelUtils) throws ScaModelUtils.InvalidScaModelException {
        this(scaModelUtils.getCompositeFile(mainCompositeFile), rootContainers, scaModelUtils);
    }

    public SuperComposite(Composite mainComposite, IContainer[] rootContainers, ScaModelUtils scaModelUtils) {
        if (mainComposite == null) {
            throw new NullPointerException("The main composite cannot be null.");
        }
        if (rootContainers == null) {
            throw new NullPointerException("The root containers cannot be null.");
        }
        if (rootContainers.length == 0) {
            throw new IllegalArgumentException("The root containers cannot be empty.");
        }
        if (scaModelUtils == null) {
            throw new NullPointerException("The SCA model utilities manager cannot be null.");
        }
        this.mainComposite = mainComposite;
        this.rootContainers = rootContainers;
        this.scaModelUtils = scaModelUtils;
        this.refresh();
    }

    public EList<Adapter> eAdapters() {
        return this.mainComposite.eAdapters();
    }

    public TreeIterator<EObject> eAllContents() {
        return this.mainComposite.eAllContents();
    }

    public EClass eClass() {
        return this.mainComposite.eClass();
    }

    public EObject eContainer() {
        return this.mainComposite.eContainer();
    }

    public EStructuralFeature eContainingFeature() {
        return this.mainComposite.eContainingFeature();
    }

    public EReference eContainmentFeature() {
        return this.mainComposite.eContainmentFeature();
    }

    public EList<EObject> eContents() {
        return this.mainComposite.eContents();
    }

    public EList<EObject> eCrossReferences() {
        return this.mainComposite.eCrossReferences();
    }

    public boolean eDeliver() {
        return this.mainComposite.eDeliver();
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return this.mainComposite.eGet(feature, resolve);
    }

    public Object eGet(EStructuralFeature feature) {
        return this.mainComposite.eGet(feature);
    }

    public boolean eIsProxy() {
        return this.mainComposite.eIsProxy();
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return this.mainComposite.eIsSet(feature);
    }

    public void eNotify(Notification notification) {
        this.mainComposite.eNotify(notification);
    }

    public Resource eResource() {
        return this.mainComposite.eResource();
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
        this.mainComposite.eSet(feature, newValue);
    }

    public void eSetDeliver(boolean deliver) {
        this.mainComposite.eSetDeliver(deliver);
    }

    public void eUnset(EStructuralFeature feature) {
        this.mainComposite.eUnset(feature);
    }

    public List<QName> getPolicySets() {
        return this.mainComposite.getPolicySets();
    }

    public List<QName> getRequires() {
        return this.mainComposite.getRequires();
    }

    public boolean isSetAutowire() {
        return this.mainComposite.isSetAutowire();
    }

    public boolean isSetLocal() {
        return this.mainComposite.isSetLocal();
    }

    public void unsetAutowire() {
        this.mainComposite.unsetAutowire();
    }

    public void unsetLocal() {
        this.mainComposite.unsetLocal();
    }

    public FeatureMap getAny() {
        return this.mainComposite.getAny();
    }

    public FeatureMap getAnyAttribute() {
        return this.mainComposite.getAnyAttribute();
    }

    public EList<Component> getMainComponents() {
        return this.mainComposite.getComponent();
    }

    public QName getConstrainingType() {
        return this.mainComposite.getConstrainingType();
    }

    public FeatureMap getGroup() {
        return this.mainComposite.getGroup();
    }

    public EList<Include> getInclude() {
        return this.mainComposite.getInclude();
    }

    public String getName() {
        return this.mainComposite.getName();
    }

    public List<QName> getMainPolicySets() {
        return this.mainComposite.getPolicySets();
    }

    public EList<Property> getMainProperties() {
        return this.mainComposite.getProperty();
    }

    public EList<Reference> getMainReferences() {
        return this.mainComposite.getReference();
    }

    public List<QName> getMainRequires() {
        return this.mainComposite.getRequires();
    }

    public EList<Service> getMainServices() {
        return this.mainComposite.getService();
    }

    public String getTargetNamespace() {
        return this.mainComposite.getTargetNamespace();
    }

    public EList<Wire> getWire() {
        return this.mainComposite.getWire();
    }

    public boolean isAutowire() {
        return this.mainComposite.isAutowire();
    }

    public boolean isLocal() {
        return this.mainComposite.isLocal();
    }

    public void setAutowire(boolean value) {
        this.mainComposite.setAutowire(value);
    }

    public void setConstrainingType(QName value) {
        this.mainComposite.setConstrainingType(value);
    }

    public void setLocal(boolean value) {
        this.mainComposite.setLocal(value);
    }

    public void setName(String value) {
        this.mainComposite.setName(value);
    }

    public void setPolicySets(List<QName> value) {
        this.mainComposite.setPolicySets(value);
    }

    public void setRequires(List<QName> value) {
        this.mainComposite.setRequires(value);
    }

    public void setTargetNamespace(String value) {
        this.mainComposite.setTargetNamespace(value);
    }

    public Composite getMainComposite() {
        return this.mainComposite;
    }

    public IContainer[] getRootContainers() {
        return this.rootContainers;
    }

    public List<SuperComposite> getResolvedInclusions() {
        return this.resolvedInclusions;
    }

    public List<Include> getUnresolvedInclusions() {
        return this.unresolvedInclusions;
    }

    public List<Service> getIncludedServices() {
        if (this.includedServices == null) {
            this.includedServices = new ArrayList<Service>();
            for (SuperComposite sc : this.resolvedInclusions) {
                this.includedServices.addAll((Collection<Service>)sc.getService());
            }
        }
        return this.includedServices;
    }

    public List<Reference> getIncludedReferences() {
        if (this.includedReferences == null) {
            this.includedReferences = new ArrayList<Reference>();
            for (SuperComposite sc : this.resolvedInclusions) {
                this.includedReferences.addAll((Collection<Reference>)sc.getReference());
            }
        }
        return this.includedReferences;
    }

    public List<Property> getIncludedProperties() {
        if (this.includedProperties == null) {
            this.includedProperties = new ArrayList<Property>();
            for (SuperComposite sc : this.resolvedInclusions) {
                this.includedProperties.addAll((Collection<Property>)sc.getProperty());
            }
        }
        return this.includedProperties;
    }

    public List<Component> getIncludedComponents() {
        if (this.includedComponents == null) {
            this.includedComponents = new ArrayList<Component>();
            for (SuperComposite sc : this.resolvedInclusions) {
                this.includedComponents.addAll((Collection<Component>)sc.getComponent());
            }
        }
        return this.includedComponents;
    }

    public List<Service> getImplementationServices() {
        if (this.implementationServices == null) {
            this.implementationServices = new ArrayList<Service>();
        }
        return this.implementationServices;
    }

    public List<Reference> getImplementationReferences() {
        if (this.implementationReferences == null) {
            this.implementationReferences = new ArrayList<Reference>();
        }
        return this.implementationReferences;
    }

    public List<Property> getImplementationProperties() {
        if (this.implementationProperties == null) {
            this.implementationProperties = new ArrayList<Property>();
        }
        return this.implementationProperties;
    }

    public void refresh() {
        this.resolvedInclusions = null;
        this.unresolvedInclusions = null;
        this.includedProperties = null;
        this.includedReferences = null;
        this.includedServices = null;
        this.implementationProperties = null;
        this.implementationReferences = null;
        this.implementationServices = null;
        this.populateInclusions();
    }

    public EList<Service> getService() {
        EList<Service> services = this.getMainServices();
        List<Service> includedServices = this.getIncludedServices();
        List<Service> implementationServices = this.getImplementationServices();
        int size = (services != null ? services.size() : 0) + includedServices.size() + implementationServices.size();
        BasicEList allServices = new BasicEList(size);
        if (services != null) {
            allServices.addAll(services);
        }
        allServices.addAll(includedServices);
        allServices.addAll(implementationServices);
        return allServices;
    }

    public EList<Reference> getReference() {
        EList<Reference> references = this.getMainReferences();
        List<Reference> includedReferences = this.getIncludedReferences();
        List<Reference> implementationReferences = this.getImplementationReferences();
        int size = (references != null ? references.size() : 0) + includedReferences.size() + implementationReferences.size();
        BasicEList allReferences = new BasicEList(size);
        if (references != null) {
            allReferences.addAll(references);
        }
        allReferences.addAll(includedReferences);
        allReferences.addAll(implementationReferences);
        return allReferences;
    }

    public EList<Property> getProperty() {
        EList<Property> properties = this.getMainProperties();
        List<Property> includedProperties = this.getIncludedProperties();
        List<Property> implementationProperties = this.getImplementationProperties();
        int size = (properties != null ? properties.size() : 0) + includedProperties.size() + implementationProperties.size();
        BasicEList allProperties = new BasicEList(size);
        if (properties != null) {
            allProperties.addAll(properties);
        }
        allProperties.addAll(includedProperties);
        allProperties.addAll(implementationProperties);
        return allProperties;
    }

    public EList<Component> getComponent() {
        EList<Component> components = this.getMainComponents();
        List<Component> includedcomponents = this.getIncludedComponents();
        int size = (components != null ? components.size() : 0) + includedcomponents.size();
        BasicEList allComponents = new BasicEList(size);
        if (components != null) {
            allComponents.addAll(components);
        }
        allComponents.addAll(includedcomponents);
        return allComponents;
    }

    private void populateInclusions() {
        this.resolvedInclusions = new ArrayList<SuperComposite>();
        this.unresolvedInclusions = new ArrayList<Include>();
        if (this.mainComposite.getInclude() != null) {
            EList includes = this.mainComposite.getInclude();
            for (Include include : includes) {
                Composite c = this.scaModelUtils.resolveInclude(include, this.rootContainers);
                if (c != null) {
                    SuperComposite sc = new SuperComposite(c, this.rootContainers, this.scaModelUtils);
                    this.resolvedInclusions.add(sc);
                    continue;
                }
                this.unresolvedInclusions.add(include);
            }
        }
    }
}

