/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.draw2d;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.stardust.ide.simulation.ui.curves.draw2d.AWTImageTransfer;
import org.eclipse.stardust.ide.simulation.ui.curves.draw2d.SWTImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class FigureUtility {
    public static Image writeToImage(Figure figure) {
        Dimension size = figure.getSize();
        Image image = new Image((Device)Display.getCurrent(), new Rectangle(0, 0, size.width, size.height));
        GC gc = new GC((Drawable)image);
        SWTGraphics graphics = new SWTGraphics(gc);
        figure.paint((Graphics)graphics);
        return image;
    }

    public static void screenshot(Figure figure) {
        FigureUtility.screenshotByAWT(figure);
    }

    private static void screenshotBySWT(Figure figure) {
        Image image = FigureUtility.writeToImage(figure);
        org.eclipse.swt.dnd.Clipboard clipboard = new org.eclipse.swt.dnd.Clipboard(Display.getCurrent());
        clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{SWTImageTransfer.getInstance()});
        image.dispose();
    }

    private static void screenshotByAWT(Figure figure) {
        Image image = FigureUtility.writeToImage(figure);
        AWTImageTransfer transferable = new AWTImageTransfer(image);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(transferable, transferable);
        image.dispose();
    }
}

