/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfigurationList;
import org.eclipse.stardust.ide.simulation.ui.distributions.DataValueGeneratorConfiguration;
import org.eclipse.stardust.ide.simulation.ui.propertypages.NotificationDispatcherModel2GUI;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.DataValueGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdaptee;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdapter;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DefaultSimulationDataValueGeneratorPropertyPage
extends AbstractModelElementPropertyPage {
    private DataValueGeneratorPanel dataValueGeneratorPanel;
    NotificationAdapter notificationAdapter;
    NotificationDispatcherModel2GUI notificationDispatcher;

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        SimulationConfigurationList configurationList = new SimulationConfigurationList(ModelUtils.findContainingModel((EObject)element));
        if (configurationList.hasConfigurations()) {
            SimulationConfiguration mainConfiguration = configurationList.getCurrentConfiguration();
            DataType dataType = (DataType)element;
            String dataTypeClass = DataValueGeneratorConfiguration.retrieveDataTypeClass(dataType);
            DataValueGeneratorConfiguration configuration = new DataValueGeneratorConfiguration(mainConfiguration.getInterval());
            configuration.read((IExtensibleElement)element, mainConfiguration.getId());
            configuration.verifyDataTypeClass(dataTypeClass);
            this.dataValueGeneratorPanel.setConfiguration(configuration);
            this.dataValueGeneratorPanel.setConfigurationEnabled(true);
            this.dataValueGeneratorPanel.setConfigurationInfo(mainConfiguration.getName());
        } else {
            this.dataValueGeneratorPanel.setConfigurationEnabled(false);
        }
        this.registerAsListener(element);
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        this.unregisterAsListener(element);
        SimulationConfigurationList configurationList = new SimulationConfigurationList(ModelUtils.findContainingModel((EObject)element));
        if (configurationList.hasConfigurations()) {
            SimulationConfiguration mainConfiguration = configurationList.getCurrentConfiguration();
            DataType dataType = (DataType)element;
            String dataTypeClass = DataValueGeneratorConfiguration.retrieveDataTypeClass(dataType);
            DataValueGeneratorConfiguration configuration = this.dataValueGeneratorPanel.getConfiguration();
            configuration.verifyDataTypeClass(dataTypeClass);
            configuration.write((IExtensibleElement)element, mainConfiguration.getId());
            SimulationModelUtils.fireNotificationEvent((EObject)element, (Object)this);
        }
    }

    private void registerAsListener(IModelElement element) {
        if (this.notificationDispatcher == null) {
            this.notificationDispatcher = new NotificationDispatcherModel2GUI(element){

                @Override
                public boolean checkForChanges() {
                    if (DefaultSimulationDataValueGeneratorPropertyPage.this.dataValueGeneratorPanel.getConfiguration() != null) {
                        DataType dataType = (DataType)this.element;
                        String dataTypeClass = DataValueGeneratorConfiguration.retrieveDataTypeClass(dataType);
                        return dataTypeClass == null ? DefaultSimulationDataValueGeneratorPropertyPage.this.dataValueGeneratorPanel.getConfiguration().getDataTypeClassId() != null : !dataTypeClass.equals(DefaultSimulationDataValueGeneratorPropertyPage.this.dataValueGeneratorPanel.getConfiguration().getDataTypeClassId());
                    }
                    return false;
                }

                @Override
                public void updateOnChanges() {
                    if (DefaultSimulationDataValueGeneratorPropertyPage.this.dataValueGeneratorPanel.getConfiguration() != null) {
                        DataType dataType = (DataType)this.element;
                        String dataTypeClass = DataValueGeneratorConfiguration.retrieveDataTypeClass(dataType);
                        DataValueGeneratorConfiguration configuration = DefaultSimulationDataValueGeneratorPropertyPage.this.dataValueGeneratorPanel.getConfiguration();
                        configuration.verifyDataTypeClass(dataTypeClass);
                        DefaultSimulationDataValueGeneratorPropertyPage.this.dataValueGeneratorPanel.setConfiguration(configuration);
                    }
                }
            };
            this.notificationAdapter = new NotificationAdapter((NotificationAdaptee)this.notificationDispatcher);
            element.eAdapters().add((Object)this.notificationAdapter);
            AttributeType attribute = DataValueGeneratorConfiguration.getTypeAttribute((IExtensibleElement)element);
            if (attribute != null) {
                attribute.eAdapters().add((Object)this.notificationAdapter);
            }
            this.dataValueGeneratorPanel.generatorCombo.addPaintListener((PaintListener)this.notificationDispatcher);
        }
    }

    private void unregisterAsListener(IModelElement element) {
        if (this.notificationAdapter != null) {
            element.eAdapters().remove((Object)this.notificationAdapter);
            AttributeType attribute = DataValueGeneratorConfiguration.getTypeAttribute((IExtensibleElement)element);
            if (attribute != null) {
                attribute.eAdapters().remove((Object)this.notificationAdapter);
            }
        }
        if (this.notificationDispatcher != null) {
            this.dataValueGeneratorPanel.removePaintListener(this.notificationDispatcher);
        }
    }

    public Control createBody(Composite parent) {
        Composite mainComposite = FormBuilder.createComposite((Composite)parent, (int)2);
        Control specificBody = this.createPageSpecificBody(mainComposite);
        Control commonBody = this.createCommonBody(mainComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo(mainComposite);
        if (specificBody != null) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(specificBody);
        }
        if (commonBody != null) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(commonBody);
        }
        return mainComposite;
    }

    public Control createPageSpecificBody(Composite parent) {
        return null;
    }

    public Control createCommonBody(Composite parent) {
        this.dataValueGeneratorPanel = new DataValueGeneratorPanel(parent, 0);
        return this.dataValueGeneratorPanel;
    }

    public void dispose() {
        try {
            IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)this.getElement().getAdapter(IModelElementNodeSymbol.class);
            IModelElement element = (IModelElement)(symbol != null ? symbol.getModelElement() : this.getElement().getAdapter(IModelElement.class));
            if (element != null) {
                this.unregisterAsListener(element);
            }
        }
        catch (Exception exception) {}
    }
}

