/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.distributions.DataValueGeneratorConfiguration;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AbstractSimulationPanel;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.StackLayoutComposite;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DataValueGeneratorPanel
extends AbstractSimulationPanel {
    public Combo generatorCombo;
    Label dataTypeText;
    DataValueGeneratorConfiguration configuration;
    RandomDataGeneratorPanel generatorPanel;

    public DataValueGeneratorPanel(Composite parent, int style) {
        super(parent, style);
        Composite generatorBox = new Composite(this.configPanel, 0);
        Label generatorLabel = FormBuilder.createLabel((Composite)generatorBox, (String)Simulation_Modeling_Messages.DATA_VALUE_GENERATOR_TYPE);
        generatorLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                RandomDataGenerator tester = DataValueGeneratorPanel.this.generatorPanel.getConfiguration();
                System.out.println("RandomDataGenerator test (" + System.currentTimeMillis() + ")");
                int i = 1;
                while (i <= 20) {
                    System.out.println(i + ": " + tester.getRandom());
                    ++i;
                }
            }
        });
        this.generatorCombo = new Combo(generatorBox, 12);
        this.generatorCombo.setItems(new String[]{""});
        this.generatorCombo.select(0);
        this.generatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataValueGeneratorPanel.this.setDataGenerator(DataValueGeneratorPanel.this.generatorCombo.getItem(DataValueGeneratorPanel.this.generatorCombo.getSelectionIndex()));
            }
        });
        this.detailsStackBox = new StackLayoutComposite(this.configPanel, 0);
        this.emptyDetailsPanel = this.buildEmptyPanel(this.detailsStackBox);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)generatorBox);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.detailsStackBox);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(8, 8).numColumns(2).applyTo(generatorBox);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)generatorLabel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.generatorCombo);
        this.detailsStackBox.setTopControl(this.emptyDetailsPanel);
    }

    protected Composite buildEmptyPanel(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        this.createFill(mainPanel);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(0, 0).numColumns(1).applyTo(mainPanel);
        return mainPanel;
    }

    @Override
    protected boolean showAuditCheckBox() {
        return false;
    }

    public void setDataGenerator(String generatorName) {
        if (this.generatorPanel != null) {
            this.generatorPanel.dispose();
        }
        if (this.configuration != null) {
            String generatorId = this.configuration.getGeneratorId(generatorName);
            this.generatorPanel = this.configuration.createGenerator(generatorId).createPanel(this.detailsStackBox);
            this.detailsStackBox.setTopControl(this.generatorPanel);
        }
        this.redraw();
    }

    public void setConfiguration(DataValueGeneratorConfiguration configuration) {
        if (this.generatorPanel != null) {
            this.generatorPanel.dispose();
        }
        this.configuration = configuration;
        if (configuration != null) {
            this.generatorPanel = configuration.getGenerator().createPanel(this.detailsStackBox);
            this.detailsStackBox.setTopControl(this.generatorPanel);
            String[] availableGeneratorClasses = configuration.getAvailableGeneratorClasses();
            String[] availableGenerators = new String[availableGeneratorClasses.length];
            int selectedGenerator = 0;
            int i = 0;
            while (i < availableGenerators.length) {
                availableGenerators[i] = configuration.getGeneratorName(availableGeneratorClasses[i]);
                if (configuration.getGenerator().getClass().getName().equals(availableGeneratorClasses[i])) {
                    selectedGenerator = i;
                }
                ++i;
            }
            this.generatorCombo.setItems(availableGenerators);
            this.generatorCombo.select(selectedGenerator);
        }
        this.redraw();
    }

    public DataValueGeneratorConfiguration getConfiguration() {
        if (this.configuration != null && this.generatorPanel != null) {
            this.configuration.setGenerator(this.generatorPanel.getConfiguration());
        }
        return this.configuration;
    }
}

