/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.common.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.DisplayName;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.common.ResAuthTypeBase;
import org.eclipse.jst.j2ee.common.ResSharingScopeType;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.webapplication.DispatcherType;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WelcomeFileList;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;

public class WebXmlUtils {
    public static ParamValue addContextParam(WebApp webApp, String name, String value) {
        return WebXmlUtils.addParam((List)webApp.getContextParams(), name, value);
    }

    public static ParamValue addContextParamValue(WebApp webApp, String name, String value) {
        return WebXmlUtils.addParamValue((List)webApp.getContextParams(), name, value);
    }

    public static ParamValue removeContextParamValue(WebApp webApp, String name, String value) {
        return WebXmlUtils.removeParamValue((List)webApp.getContextParams(), name, value);
    }

    public static ParamValue findContextParam(WebApp webApp, String name) {
        return WebXmlUtils.findParam((List)webApp.getContextParams(), name);
    }

    public static boolean removeContextParam(WebApp webApp, String name) {
        return WebXmlUtils.removeParam((List)webApp.getContextParams(), name);
    }

    public static boolean removeContextParam(WebApp webApp, ParamValue param) {
        return WebXmlUtils.removeParam((List)webApp.getContextParams(), param);
    }

    public static Listener addListener(WebApp webApp, String className) {
        Listener listener = WebXmlUtils.findListener(webApp, className);
        if (listener == null) {
            listener = CommonFactory.eINSTANCE.createListener();
            listener.setListenerClassName(className);
            webApp.getListeners().add((Object)listener);
        }
        return listener;
    }

    public static Listener findListener(WebApp webApp, String className) {
        Listener result = null;
        int i = 0;
        while (i < webApp.getListeners().size()) {
            Listener listener = (Listener)webApp.getListeners().get(i);
            if (CompareHelper.areEqual((Object)className, (Object)listener.getListenerClassName())) {
                result = listener;
                break;
            }
            ++i;
        }
        return result;
    }

    public static boolean removeListener(WebApp root, String className) {
        boolean deleted = false;
        Listener listener = WebXmlUtils.findListener(root, className);
        if (listener != null) {
            deleted = WebXmlUtils.removeListener(root, listener);
        }
        return deleted;
    }

    public static boolean removeListener(WebApp webApp, Listener listener) {
        boolean deleted = false;
        if (listener != null) {
            deleted = webApp.getListeners().remove((Object)listener);
        }
        return deleted;
    }

    public static Servlet addServlet(WebApp webApp, String name, String className) {
        Servlet servlet = WebXmlUtils.findServlet(webApp, name, className);
        if (servlet == null) {
            servlet = WebapplicationFactory.eINSTANCE.createServlet();
            servlet.setServletName(name);
            ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
            servletType.setClassName(className);
            servlet.setWebType((WebType)servletType);
            webApp.getServlets().add((Object)servlet);
        }
        return servlet;
    }

    public static Servlet addServlet(WebApp webApp, String name, String className, int loadOnStartup) {
        Servlet servlet = WebXmlUtils.addServlet(webApp, name, className);
        servlet.setLoadOnStartup(new Integer(loadOnStartup));
        return servlet;
    }

    public static Servlet findServlet(WebApp webApp, String name, String className) {
        Servlet result = null;
        int i = 0;
        while (i < webApp.getServlets().size()) {
            ServletType servletType;
            Servlet servlet = (Servlet)webApp.getServlets().get(i);
            ServletType servletType2 = servletType = !StringUtils.isEmpty((String)className) && servlet.getWebType() instanceof ServletType ? (ServletType)servlet.getWebType() : null;
            if ((StringUtils.isEmpty((String)name) || name.equals(servlet.getServletName())) && (servletType == null || className.equals(servletType.getClassName()))) {
                result = servlet;
                break;
            }
            ++i;
        }
        return result;
    }

    public static boolean removeServlet(WebApp webApp, Servlet servlet) {
        boolean deleted = false;
        if (servlet != null) {
            deleted = webApp.getServlets().remove((Object)servlet);
        }
        return deleted;
    }

    public static ServletMapping addServletMapping(WebApp webApp, Servlet servlet, String urlMapping) {
        ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
        mapping.setServlet(servlet);
        mapping.setUrlPattern(urlMapping);
        if (WebXmlUtils.findServletMapping(webApp, servlet, urlMapping) == null) {
            webApp.getServletMappings().add((Object)mapping);
        }
        return mapping;
    }

    public static ServletMapping findServletMapping(WebApp webApp, Servlet servlet, String urlMapping) {
        ServletMapping result = null;
        int i = 0;
        while (i < webApp.getServletMappings().size()) {
            ServletMapping mapping = (ServletMapping)webApp.getServletMappings().get(i);
            if ((servlet == null || servlet.equals(mapping.getServlet())) && (StringUtils.isEmpty((String)urlMapping) || urlMapping.equals(mapping.getUrlPattern()))) {
                result = mapping;
                break;
            }
            ++i;
        }
        return result;
    }

    public static List<ServletMapping> findServletMappings(WebApp webApp, Servlet servlet) {
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>();
        int i = 0;
        while (i < webApp.getServletMappings().size()) {
            ServletMapping mapping = (ServletMapping)webApp.getServletMappings().get(i);
            if (servlet.equals(mapping.getServlet())) {
                mappings.add(mapping);
            }
            ++i;
        }
        return mappings;
    }

    public static boolean removeServletMapping(WebApp webApp, Servlet servlet, String urlMapping) {
        boolean deleted = false;
        ServletMapping mapping = WebXmlUtils.findServletMapping(webApp, servlet, urlMapping);
        if (mapping != null) {
            deleted = WebXmlUtils.removeServletMapping(webApp, mapping);
        }
        return deleted;
    }

    public static boolean removeServletMapping(WebApp webApp, ServletMapping mapping) {
        boolean deleted = false;
        if (mapping != null) {
            deleted = webApp.getServletMappings().remove((Object)mapping);
        }
        return deleted;
    }

    public static ParamValue addServletParam(Servlet servlet, String name, String value) {
        return WebXmlUtils.addParam((List)servlet.getInitParams(), name, value);
    }

    public static ParamValue addServletParamValue(Servlet servlet, String name, String value) {
        return WebXmlUtils.addParamValue((List)servlet.getInitParams(), name, value);
    }

    public static ParamValue removeServletParamValue(Servlet servlet, String name, String value) {
        return WebXmlUtils.removeParamValue((List)servlet.getInitParams(), name, value);
    }

    public static ParamValue findServletParam(Servlet servlet, String name) {
        return WebXmlUtils.findParam((List)servlet.getInitParams(), name);
    }

    public static boolean removeServletParam(Servlet servlet, String name) {
        if (servlet == null) {
            return true;
        }
        return WebXmlUtils.removeParam((List)servlet.getInitParams(), name);
    }

    public static boolean removeServletParam(Servlet servlet, ParamValue param) {
        return WebXmlUtils.removeParam((List)servlet.getInitParams(), param);
    }

    public static DisplayName addServletDisplayName(Servlet servlet, String name) {
        DisplayName displayName = CommonFactory.eINSTANCE.createDisplayName();
        displayName.setValue(name);
        servlet.getDisplayNames().add((Object)displayName);
        return displayName;
    }

    public static Description addServletDescription(Servlet servlet, String description) {
        Description servletDescription = CommonFactory.eINSTANCE.createDescription();
        servletDescription.setValue(description);
        servlet.getDescriptions().add((Object)servletDescription);
        return servletDescription;
    }

    public static Filter addFilter(WebApp webApp, String name, String className) {
        Filter filter = WebapplicationFactory.eINSTANCE.createFilter();
        filter.setName(name);
        filter.setFilterClassName(className);
        webApp.getFilters().add((Object)filter);
        return filter;
    }

    public static Filter findFilter(WebApp webApp, String name, String className) {
        Filter result = null;
        EList filterList = webApp.getFilters();
        int i = 0;
        while (i < filterList.size()) {
            Filter filter = (Filter)filterList.get(i);
            if (name.equals(filter.getName()) && className.equals(filter.getFilterClassName())) {
                result = filter;
                break;
            }
            ++i;
        }
        return result;
    }

    public static boolean removeFilter(WebApp webApp, Filter filter) {
        return webApp.getFilters().remove((Object)filter);
    }

    public static void addFilterParam(WebApp webApp, Filter filter, String name, String value) {
        if (webApp.getJ2EEVersionID() >= 14) {
            ParamValue initParam = CommonFactory.eINSTANCE.createParamValue();
            initParam.setName(name);
            initParam.setValue(value);
            filter.getInitParamValues().add((Object)initParam);
        } else {
            InitParam initParam = WebapplicationFactory.eINSTANCE.createInitParam();
            initParam.setParamName(name);
            initParam.setParamValue(value);
            filter.getInitParams().add((Object)initParam);
        }
    }

    public static boolean removeFilterParam(WebApp webApp, Filter filter, String name) {
        boolean deleted = false;
        if (webApp.getJ2EEVersionID() >= 14) {
            ParamValue param = WebXmlUtils.findFilterParamJ2EE14(filter, name);
            if (param != null) {
                deleted = filter.getInitParamValues().remove((Object)param);
            }
        } else {
            InitParam param = WebXmlUtils.findFilterParamJ2EE13(filter, name);
            if (param != null) {
                deleted = filter.getInitParams().remove((Object)param);
            }
        }
        return deleted;
    }

    protected static InitParam findFilterParamJ2EE13(Filter filter, String name) {
        InitParam result = null;
        if (filter != null) {
            EList paramList = filter.getInitParams();
            int i = 0;
            while (i < paramList.size()) {
                InitParam param = (InitParam)paramList.get(i);
                if (name.equals(param.getParamName())) {
                    result = param;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    protected static ParamValue findFilterParamJ2EE14(Filter filter, String name) {
        ParamValue result = null;
        if (filter != null) {
            EList paramList = filter.getInitParamValues();
            int i = 0;
            while (i < paramList.size()) {
                ParamValue param = (ParamValue)paramList.get(i);
                if (name.equals(param.getName())) {
                    result = param;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static Filter addFilterMapping(WebApp webApp, Filter filter, Servlet servlet) {
        FilterMapping filterMapping = WebapplicationFactory.eINSTANCE.createFilterMapping();
        filterMapping.setFilter(filter);
        filterMapping.setServlet(servlet);
        webApp.getFilterMappings().add((Object)filterMapping);
        return filter;
    }

    public static boolean removeFilterMapping(WebApp webApp, Filter filter, Servlet servlet) {
        boolean deleted = false;
        FilterMapping mapping = WebXmlUtils.findFilterMapping(webApp, filter, servlet);
        if (mapping != null) {
            deleted = webApp.getFilterMappings().remove((Object)mapping);
        }
        return deleted;
    }

    public static FilterMapping findFilterMapping(WebApp webApp, Filter filter, Servlet servlet) {
        FilterMapping result = null;
        if (filter == null || servlet == null) {
            return null;
        }
        EList mappingList = webApp.getFilterMappings();
        int i = 0;
        while (i < mappingList.size()) {
            FilterMapping mapping = (FilterMapping)mappingList.get(i);
            if (filter.equals(mapping.getFilter()) && servlet.equals(mapping.getServlet())) {
                result = mapping;
                break;
            }
            ++i;
        }
        return result;
    }

    public static Filter addFilterMapping(WebApp webApp, Filter filter, String urlPattern) {
        return WebXmlUtils.addFilterMapping(webApp, filter, urlPattern, null);
    }

    public static Filter addFilterMapping(WebApp webApp, Filter filter, String urlPattern, String[] dispatcherTypes) {
        FilterMapping filterMapping = WebapplicationFactory.eINSTANCE.createFilterMapping();
        filterMapping.setFilter(filter);
        filterMapping.setUrlPattern(urlPattern);
        if (dispatcherTypes != null && dispatcherTypes.length > 0) {
            EList dispatcherList = filterMapping.getDispatcherType();
            DispatcherType[] cfr_ignored_0 = new DispatcherType[dispatcherTypes.length];
            int i = 0;
            while (i < dispatcherTypes.length) {
                String type = dispatcherTypes[i];
                DispatcherType dispatcherType = DispatcherType.getByName((String)type);
                if (dispatcherType != null) {
                    dispatcherList.add((Object)dispatcherType);
                }
                ++i;
            }
        }
        webApp.getFilterMappings().add((Object)filterMapping);
        return filter;
    }

    public static boolean removeFilterMapping(WebApp webApp, Filter filter, String urlPattern) {
        boolean deleted = false;
        FilterMapping mapping = WebXmlUtils.findFilterMapping(webApp, filter, urlPattern);
        if (mapping != null) {
            deleted = webApp.getFilterMappings().remove((Object)mapping);
        }
        return deleted;
    }

    public static FilterMapping findFilterMapping(WebApp webApp, Filter filter, String urlPattern) {
        FilterMapping result = null;
        if (filter == null || urlPattern == null) {
            return null;
        }
        EList mappingList = webApp.getFilterMappings();
        int i = 0;
        while (i < mappingList.size()) {
            FilterMapping mapping = (FilterMapping)mappingList.get(i);
            if (filter.equals(mapping.getFilter()) && urlPattern.equals(mapping.getUrlPattern())) {
                result = mapping;
                break;
            }
            ++i;
        }
        return result;
    }

    public static WelcomeFileList addWelcomeFileList(WebApp webApp, String[] files) {
        WelcomeFileList welcomeFileList = WebapplicationFactory.eINSTANCE.createWelcomeFileList();
        int i = 0;
        while (i < files.length) {
            welcomeFileList.addFileNamed(files[i]);
            ++i;
        }
        webApp.setFileList(welcomeFileList);
        return welcomeFileList;
    }

    public static TagLibRef addTagLibRef(WebApp webApp, String uri, String location) {
        TagLibRef tldRef = WebXmlUtils.findTagLibRef(webApp, uri);
        if (tldRef == null) {
            tldRef = WebapplicationFactory.eINSTANCE.createTagLibRef();
            tldRef.setTaglibURI(uri);
            tldRef.setTaglibLocation(location);
            webApp.getTagLibs().add((Object)tldRef);
        }
        return tldRef;
    }

    public static ResourceRef addResourceRef(WebApp webApp, String name, String type) {
        return WebXmlUtils.addResourceRef(webApp, name, type, true);
    }

    public static ResourceRef addResourceRef(WebApp webApp, String name, String type, boolean shareable) {
        ResourceRef resRef = WebXmlUtils.findResourceRef(webApp, name, type);
        if (resRef == null) {
            resRef = CommonFactory.eINSTANCE.createResourceRef();
            resRef.setName(name);
            resRef.setType(type);
            resRef.setAuth(ResAuthTypeBase.CONTAINER_LITERAL);
            resRef.setResSharingScope(shareable ? ResSharingScopeType.SHAREABLE_LITERAL : ResSharingScopeType.UNSHAREABLE_LITERAL);
            webApp.getResourceRefs().add((Object)resRef);
        }
        return resRef;
    }

    public static ResourceRef findResourceRef(WebApp webApp, String name, String type) {
        ResourceRef result = null;
        EList refList = webApp.getResourceRefs();
        int i = 0;
        while (i < refList.size()) {
            ResourceRef ref = (ResourceRef)refList.get(i);
            if (name.equals(ref.getName()) && type.equals(ref.getType())) {
                result = ref;
                break;
            }
            ++i;
        }
        return result;
    }

    public static TagLibRef findTagLibRef(WebApp webApp, String uri) {
        TagLibRef result = null;
        EList refList = webApp.getTagLibs();
        int i = 0;
        while (i < refList.size()) {
            TagLibRef ref = (TagLibRef)refList.get(i);
            if (uri.equals(ref.getTaglibURI())) {
                result = ref;
                break;
            }
            ++i;
        }
        return result;
    }

    public static List parseParamValues(WebApp webApp, String name) {
        return WebXmlUtils.parseParamValues((List)webApp.getContextParams(), name);
    }

    public static List parseParamValues(Servlet servlet, String name) {
        return WebXmlUtils.parseParamValues((List)servlet.getInitParams(), name);
    }

    private static ParamValue addParam(List params, String name, String value) {
        ParamValue param = CommonFactory.eINSTANCE.createParamValue();
        param.setName(name);
        param.setValue(value != null ? value : "");
        ParamValue currentValue = WebXmlUtils.findParam(params, name);
        if (currentValue != null) {
            int idx = params.indexOf(currentValue);
            params.set(idx, param);
        } else {
            params.add(param);
        }
        return param;
    }

    private static ParamValue addParamValue(List params, String name, String value) {
        List values = WebXmlUtils.parseParamValues(params, name);
        if (!values.contains(value)) {
            values.add(value);
        }
        return WebXmlUtils.addParam(params, name, StringUtils.join(values.iterator(), (String)","));
    }

    private static ParamValue removeParamValue(List params, String name, String value) {
        List values = WebXmlUtils.parseParamValues(params, name);
        if (values.contains(value)) {
            values.remove(value);
        }
        return WebXmlUtils.addParam(params, name, StringUtils.join(values.iterator(), (String)","));
    }

    private static ParamValue findParam(List params, String name) {
        ParamValue result = null;
        for (ParamValue param : params) {
            if (!CompareHelper.areEqual((Object)name, (Object)param.getName())) continue;
            result = param;
            break;
        }
        return result;
    }

    private static boolean removeParam(List params, String name) {
        boolean deleted = false;
        ParamValue param = WebXmlUtils.findParam(params, name);
        if (param != null) {
            deleted = WebXmlUtils.removeParam(params, param);
        }
        return deleted;
    }

    private static boolean removeParam(List params, ParamValue param) {
        boolean deleted = false;
        if (param != null) {
            deleted = params.remove(param);
        }
        return deleted;
    }

    private static List parseParamValues(List params, String name) {
        ArrayList<String> values = new ArrayList<String>();
        ParamValue result = WebXmlUtils.findParam(params, name);
        if (result != null) {
            Iterator i = StringUtils.split((String)result.getValue(), (char)',');
            while (i.hasNext()) {
                String entry = (String)i.next();
                if (StringUtils.isEmpty((String)entry)) continue;
                values.add(entry);
            }
        }
        return values;
    }

    public static boolean removeResourceRef(WebApp webApp, ResourceRef auditTrail) {
        boolean deleted = false;
        if (auditTrail != null) {
            deleted = webApp.getResourceRefs().remove((Object)auditTrail);
        }
        return deleted;
    }
}

