/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.generation;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.struct.StructuredTypeRtUtils;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.MappedType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IBridgeObjectProvider;
import org.eclipse.stardust.modeling.validation.ValidatorRegistry;

public class GenericDataMapping {
    private DataMappingType dataMapping;
    private MappedType mappedType;

    public boolean isSupported() {
        return this.mappedType.getMappedType() == String.class || this.mappedType.getMappedType() == Character.class || this.mappedType.getMappedType() == Double.class || this.mappedType.getMappedType() == Float.class || this.mappedType.getMappedType() == Long.class || this.mappedType.getMappedType() == Integer.class || this.mappedType.getMappedType() == Short.class || this.mappedType.getMappedType() == Byte.class || this.mappedType.getMappedType() == Date.class || this.mappedType.getMappedType() == Calendar.class || this.mappedType.getMappedType() == Boolean.class || StructuredTypeRtUtils.isStructuredType((String)this.dataMapping.getData().getType().getId()) || StructuredTypeRtUtils.isDmsType((String)this.dataMapping.getData().getType().getId());
    }

    public boolean isInteger() {
        return this.mappedType.getMappedType() == Long.class || this.mappedType.getMappedType() == Integer.class || this.mappedType.getMappedType() == Short.class || this.mappedType.getMappedType() == Byte.class;
    }

    public boolean isNumber() {
        return this.mappedType.getMappedType() == Long.class || this.mappedType.getMappedType() == Integer.class || this.mappedType.getMappedType() == Short.class || this.mappedType.getMappedType() == Byte.class || this.mappedType.getMappedType() == Double.class || this.mappedType.getMappedType() == Float.class;
    }

    public void setControlType(int controlType) {
        this.mappedType.setControlType(controlType);
    }

    public static int getAlternateControlTypeForMapping(GenericDataMapping mapping) {
        if (mapping.getMappedType().getMappedType().equals(Boolean.class)) {
            return 2;
        }
        return 1;
    }

    public static int getAlternate2ControlTypeForMapping(GenericDataMapping mapping) {
        if (mapping.getMappedType().getMappedType().equals(String.class)) {
            return 4;
        }
        return 0;
    }

    public static List<GenericDataMapping> generateGenericDataMappingFromDataMappings(List<DataMappingType> dataMappings) {
        ArrayList<GenericDataMapping> genericDataMappings = new ArrayList<GenericDataMapping>(dataMappings.size());
        int i = 0;
        while (i < dataMappings.size()) {
            GenericDataMapping genericDataMapping;
            DataMappingType dataMapping = dataMappings.get(i);
            if ("default".equals(dataMapping.getContext()) && (genericDataMapping = new GenericDataMapping(dataMapping)).isSupported()) {
                genericDataMappings.add(genericDataMapping);
            }
            ++i;
        }
        return genericDataMappings;
    }

    public GenericDataMapping(DataMappingType dataMapping) {
        this.dataMapping = dataMapping;
        this.mappedType = new MappedType(GenericDataMapping.getMappedType(dataMapping), 0);
    }

    public DataMappingType getDataMapping() {
        return this.dataMapping;
    }

    public MappedType getMappedType() {
        return this.mappedType;
    }

    public String getId() {
        return this.dataMapping.getId();
    }

    private static Class<?> getMappedType(DataMappingType dataMapping) {
        Class<?> mappedType = null;
        if (dataMapping.getData() != null) {
            IBridgeObjectProvider provider = ValidatorRegistry.getBridgeObjectProvider((ITypedElement)dataMapping.getData());
            DirectionType direction = dataMapping.getDirection();
            if (DirectionType.IN_LITERAL.equals((Object)direction)) {
                direction = DirectionType.OUT_LITERAL;
            } else if (DirectionType.OUT_LITERAL.equals((Object)direction)) {
                direction = DirectionType.IN_LITERAL;
            }
            if (provider != null) {
                BridgeObject bridge = provider.getBridgeObject((ITypedElement)dataMapping.getData(), dataMapping.getDataPath(), direction);
                IType endClass = bridge.getEndClass();
                try {
                    mappedType = Class.forName(endClass.getFullyQualifiedName());
                }
                catch (Exception exception) {}
            }
        }
        return mappedType;
    }

    public int getControlType() {
        return this.mappedType.getControlType();
    }

    public String getBooleanMethodName(boolean value) {
        return "process" + (value ? "True" : "False") + this.getId();
    }

    public String getPropertyName() {
        String name = Introspector.decapitalize(this.getId());
        return this.mappedType.getMappedType() == Calendar.class ? String.valueOf(name) + "AsDate" : name;
    }

    public String getLabel() {
        String name = this.dataMapping.getName();
        if (StringUtils.isEmpty((String)this.dataMapping.getDataPath())) {
            name = this.dataMapping.getData().getName();
        }
        return name;
    }

    public String getAccessorMethodsName() {
        return this.getId();
    }

    public String getStructuredAccessorMethodsName() {
        return String.valueOf(this.getAccessorMethodsName()) + "Wrapper";
    }

    public String getCalendarAccessorMethodsName() {
        return String.valueOf(this.getAccessorMethodsName()) + "AsDate";
    }
}

