/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IStardustExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.spi.StardustExtensionRegistry;
import org.osgi.framework.Bundle;

public class SpiExtensionRegistry {
    public static final String FEATURE_PREFIX = "feature:";
    private static SpiExtensionRegistry instance;
    private IStardustExtensionRegistry extensionRegistry = StardustExtensionRegistry.instance();
    private Map<String, Map<String, IConfigurationElement>> registry = CollectionUtils.newMap();
    private Map<String, List<IConfigurationElement>> registry_ = CollectionUtils.newMap();
    private static Map<IConfigurationElement, Contributor> contributors;

    static {
        contributors = CollectionUtils.newMap();
    }

    public static SpiExtensionRegistry instance() {
        if (instance == null) {
            instance = new SpiExtensionRegistry();
        }
        return instance;
    }

    public void setExtensionRegistry(IStardustExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    public Map<String, IConfigurationElement> getExtensions(String extensionPointId) {
        return this.getExtensions("org.eclipse.stardust.modeling.core", extensionPointId);
    }

    public Map<String, IConfigurationElement> getExtensions(String packageName, String extensionPointId) {
        String expandedId = String.valueOf(packageName) + "." + extensionPointId;
        Map<String, IConfigurationElement> extensions = this.registry.get(expandedId);
        if (extensions == null) {
            extensions = new TreeMap<String, IConfigurationElement>();
            this.registry.put(expandedId, extensions);
            this.addExternalExtensions(extensions, expandedId);
        }
        return extensions;
    }

    public List<IConfigurationElement> getExtensionList(String extensionPointId) {
        return this.getExtensionList("org.eclipse.stardust.modeling.core", extensionPointId);
    }

    public List<IConfigurationElement> getExtensionList(String packageName, String extensionPointId) {
        String expandedId = String.valueOf(packageName) + "." + extensionPointId;
        List extensions = null;
        try {
            extensions = this.registry_.get(expandedId);
            if (extensions == null) {
                extensions = CollectionUtils.newList();
                this.registry_.put(expandedId, extensions);
                if (this.extensionRegistry != null) {
                    IExtensionPoint extensionPoint = this.extensionRegistry.getExtensionPoint(expandedId);
                    IExtension[] extension = extensionPoint.getExtensions();
                    int i = 0;
                    while (i < extension.length) {
                        IConfigurationElement[] configuration = extension[i].getConfigurationElements();
                        int j = 0;
                        while (j < configuration.length) {
                            extensions.add(configuration[j]);
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception exception) {}
        return extensions;
    }

    private void addExternalExtensions(Map<String, IConfigurationElement> extensions, String expandedId) {
        try {
            IExtensionPoint extensionPoint;
            if (this.extensionRegistry != null && (extensionPoint = this.extensionRegistry.getExtensionPoint(expandedId)) != null) {
                IExtension[] extension = extensionPoint.getExtensions();
                int i = 0;
                while (i < extension.length) {
                    IConfigurationElement[] configuration = extension[i].getConfigurationElements();
                    int j = 0;
                    while (j < configuration.length) {
                        String id = configuration[j].getAttribute("id");
                        extensions.put(id, configuration[j]);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
    }

    public static void stop() {
        if (instance != null) {
            SpiExtensionRegistry.instance.registry.clear();
        }
    }

    public String getTypeIcon(String extensionPointId, String type) {
        Map<String, IConfigurationElement> extensions = this.getExtensions(extensionPointId);
        IConfigurationElement element = extensions.get(type);
        return element == null ? null : SpiExtensionRegistry.encodeExtensionIcon(element);
    }

    public static Object createPropertyPage(String pageId, String metaType) {
        return SpiExtensionRegistry.createExecutableExtension("org.eclipse.ui.propertyPages", "class", pageId, "filter", "metaType", metaType);
    }

    public static Object createExecutableExtension(String extensionId, String classAttribute, String objectId, String childFilterName, String filterName, String filterValue) {
        try {
            IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionId);
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement cfg = extensions[i];
                String id = cfg.getAttribute("id");
                if (objectId.equals(id)) {
                    if (childFilterName == null) {
                        return cfg.createExecutableExtension(classAttribute);
                    }
                    IConfigurationElement[] filters = cfg.getChildren(childFilterName);
                    int j = 0;
                    while (j < filters.length) {
                        String name = filters[j].getAttribute("name");
                        String value = filters[j].getAttribute("value");
                        if (filterName.equals(name) && filterValue.equals(value)) {
                            return cfg.createExecutableExtension(classAttribute);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IConfigurationElement getConfiguration(IExtensibleElement extensible) {
        Map<String, IConfigurationElement> extensions;
        IMetaType type;
        if (extensible instanceof ITypedElement && (type = ((ITypedElement)((Object)extensible)).getMetaType()) != null && (extensions = SpiExtensionRegistry.instance().getExtensions(type.getExtensionPointId())) != null) {
            return extensions.get(type.getId());
        }
        return null;
    }

    public static List<IConfigurationElement> getConfiguration(IExtensibleElement extensible, String id) {
        IMetaType type;
        String typeId = null;
        if (extensible instanceof ITypedElement && (type = ((ITypedElement)((Object)extensible)).getMetaType()) != null) {
            typeId = type.getId();
        }
        Class<?> extensibleClass = extensible.getClass();
        List<IConfigurationElement> extensions = SpiExtensionRegistry.instance().getExtensionList("org.eclipse.stardust.model.xpdl", id);
        if (extensions != null) {
            ArrayList<IConfigurationElement> matching = new ArrayList<IConfigurationElement>();
            for (IConfigurationElement element : extensions) {
                String classValue = element.getAttribute("class");
                String meta = element.getAttribute("meta");
                try {
                    Class<?> typeClass = Class.forName(classValue);
                    boolean isAssignable = typeClass.isAssignableFrom(extensibleClass);
                    if (!isAssignable) continue;
                    if (!StringUtils.isEmpty((String)meta)) {
                        if (StringUtils.isEmpty((String)typeId) || !typeId.equals(meta)) continue;
                        matching.add(element);
                        continue;
                    }
                    matching.add(element);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            return matching;
        }
        return null;
    }

    public static String encodeExtensionIcon(IConfigurationElement extension) {
        return "{" + extension.getContributor().getName() + "}" + extension.getAttribute("icon");
    }

    public static boolean matchFilterValue(boolean notOperator, String filterValue, String value) {
        boolean directMatch;
        boolean bl = directMatch = filterValue != null && filterValue.equals(value);
        return notOperator ? !directMatch : directMatch;
    }

    public static boolean matchFilter(IConfigurationElement[] filters, String filterName, String filterValue) {
        boolean hasFilter = false;
        int j = 0;
        while (j < filters.length) {
            boolean notOperator = false;
            String name = filters[j].getAttribute("name");
            String value = filters[j].getAttribute("value");
            if (name.startsWith("!")) {
                notOperator = true;
                name = name.substring(1);
            }
            if (filterName.equals(name)) {
                hasFilter = true;
                if (SpiExtensionRegistry.matchFilterValue(notOperator, filterValue, value)) {
                    return true;
                }
            }
            ++j;
        }
        return !hasFilter;
    }

    public static boolean isMatchingClass(Object element, String classAttributeName, IConfigurationElement template) throws ClassNotFoundException {
        Bundle bundle;
        Contributor pageContributor = contributors.get(template);
        String pageContributorEnabled = template.getAttribute("pageContributor");
        if (pageContributor == null && pageContributorEnabled == null) {
            pageContributor = new Contributor(template);
            contributors.put(template, pageContributor);
        }
        if (pageContributor != null && !pageContributor.isApplicableTo(element, classAttributeName)) {
            return false;
        }
        String objectClass = template.getAttribute(classAttributeName);
        if (StringUtils.isEmpty((String)objectClass)) {
            return true;
        }
        Class targetClass = null;
        String bundleId = null;
        if (template.getContributor() != null) {
            bundleId = template.getContributor().getName();
        }
        if (bundleId != null && (bundle = Platform.getBundle((String)bundleId)) != null && bundle.getState() == 32) {
            targetClass = bundle.loadClass(objectClass);
        }
        if (targetClass == null) {
            targetClass = Class.forName(objectClass);
        }
        return targetClass.isInstance(element);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMatchingElement(EObject element, String classAttributeName, Map<String, String> filterValues, IConfigurationElement template) {
        try {
            if (!SpiExtensionRegistry.isMatchingClass(element, classAttributeName, template)) return false;
            IConfigurationElement[] filters = template.getChildren("filter");
            for (Map.Entry<String, String> entry : filterValues.entrySet()) {
                if (SpiExtensionRegistry.matchFilter(filters, entry.getKey(), entry.getValue())) continue;
                return false;
            }
            int j = 0;
            while (j < filters.length) {
                boolean notOperator = false;
                String name = filters[j].getAttribute("name");
                String value = filters[j].getAttribute("value");
                if (name.startsWith("!")) {
                    notOperator = true;
                    name = name.substring(1);
                }
                if ("metaType".equals(name)) {
                    if (!(element instanceof ITypedElement)) {
                        return false;
                    }
                    IMetaType metaType = ((ITypedElement)element).getMetaType();
                    if (!SpiExtensionRegistry.matchFilterValue(notOperator, metaType == null ? null : metaType.getId(), value)) {
                        return false;
                    }
                }
                if (name.startsWith(FEATURE_PREFIX)) {
                    String featureName = name.substring(FEATURE_PREFIX.length());
                    Object featureValue = SpiExtensionRegistry.getFeatureValue(element, featureName);
                    if (featureValue == null) {
                        return false;
                    }
                    if (!SpiExtensionRegistry.matchFilterValue(notOperator, featureValue == null ? null : featureValue.toString(), value)) {
                        return false;
                    }
                }
                ++j;
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return false;
    }

    private static Object getFeatureValue(EObject element, String featureName) {
        String[] featureNames = featureName.split("\\.");
        if (featureNames.length > 1) {
            String first = featureNames[0];
            int end = first.length();
            String featurePart = featureName.substring(0, end);
            String featureNext = featureName.substring(end + 1);
            EStructuralFeature feature = element.eClass().getEStructuralFeature(featurePart);
            if (feature == null) {
                return null;
            }
            Object featureValue = element.eGet(feature);
            if (featureValue instanceof EObject) {
                return SpiExtensionRegistry.getFeatureValue((EObject)featureValue, featureNext);
            }
            return null;
        }
        EStructuralFeature feature = element.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            return null;
        }
        Object featureValue = element.eGet(feature);
        return featureValue;
    }

    private static class Contributor {
        private static final String CHILD_ENABLED_WHEN = "enabledWhen";
        private Expression enablementExpression;

        public Contributor(IConfigurationElement template) {
            this.initializeEnablement(template);
        }

        public boolean isApplicableTo(Object element, String classAttributeName) {
            if (this.enablementExpression == null) {
                return true;
            }
            try {
                EvaluationContext context = new EvaluationContext(null, element);
                context.setAllowPluginActivation(true);
                return this.enablementExpression.evaluate((IEvaluationContext)context).equals(EvaluationResult.TRUE);
            }
            catch (CoreException coreException) {
                return false;
            }
        }

        private void initializeEnablement(IConfigurationElement template) {
            IConfigurationElement[] elements = template.getChildren(CHILD_ENABLED_WHEN);
            if (elements.length == 0) {
                return;
            }
            try {
                IConfigurationElement[] enablement = elements[0].getChildren();
                if (enablement.length == 0) {
                    return;
                }
                this.enablementExpression = ExpressionConverter.getDefault().perform(enablement[0]);
            }
            catch (CoreException coreException) {}
        }
    }
}

